/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.util.AbstractModelBusEPackageRegistry;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.Session;

public class ModelBusPackageRegistry
extends AbstractModelBusEPackageRegistry {
    private static final long serialVersionUID = 1872524641621166113L;
    private Session session;
    private ResourceSet resourceSet;

    public void setSession(Session session) {
        this.session = session;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    protected boolean existsInRepository(URI uri) {
        try {
            return ModelBusCoreLib.getRepositoryHelper().exists(this.session, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isFileInRepository(URI uri) {
        List<RepositoryDirEntry> repositoryDirEntries;
        try {
            repositoryDirEntries = ModelBusCoreLib.getRepositoryHelper().getInfo(this.session, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (RepositoryDirEntry repositoryDirEntry : repositoryDirEntries) {
            if (!RepositoryNodeKind.FILE.equals((Object)repositoryDirEntry.getKind())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Resource checkOutModel(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        try {
            ModelBusCoreLib.getRepositoryHelper().checkOutModel(this.session, resource, Collections.EMPTY_MAP);
            return resource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<String> getDirEntryNames(URI dirURI) {
        RepositoryDirEntry[] entries;
        ArrayList<String> entryNames = new ArrayList<String>();
        try {
            entries = ModelBusCoreLib.getRepositoryHelper().getDirEntries(this.session, dirURI, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RepositoryDirEntry[] repositoryDirEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryDirEntry entry = repositoryDirEntryArray[n2];
            entryNames.add(entry.getName());
            ++n2;
        }
        return entryNames;
    }
}

