/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.activation.DataHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusRepositoryListener;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.common.AccessManager;
import org.modelbus.services.repository.server.common.ModelBusRepositoryCache;

public class ChangeCommitManager
implements IModelBusRepositoryListener {
    private IModelBusRepository modelBusRepositoryImpl;
    private ExecutorService executorService;
    private List<Resource> changedResources = new ArrayList<Resource>();
    private ModelBusRepositoryCache modelBusRepositoryCache;
    private static final long TIMER_INTERVAL = 300000L;

    public ChangeCommitManager(IModelBusRepository modelBusRepositoryImpl) {
        this.modelBusRepositoryImpl = modelBusRepositoryImpl;
        this.modelBusRepositoryImpl.addModelBusRepositoryListener(this);
        this.executorService = Executors.newSingleThreadExecutor();
        this.modelBusRepositoryCache = new ModelBusRepositoryCache(this.modelBusRepositoryImpl, 300000L);
    }

    private void applyObjectChangeEntries(TransactionalEditingDomain domain, EMap<EObject, EList<FeatureChange>> objectChanges) {
        BasicEMap entriesToApplyLater = new BasicEMap();
        int objectChangesSize = objectChanges.size();
        for (Map.Entry entry : objectChanges) {
            EObject eObject = (EObject)entry.getKey();
            Resource resourceToChange = eObject.eResource();
            if (eObject.eIsProxy()) {
                entriesToApplyLater.add((Object)entry);
                continue;
            }
            EList featureChanges = (EList)entry.getValue();
            for (FeatureChange featureChange : featureChanges) {
                EStructuralFeature feature = featureChange.getFeature();
                EList listChanges = featureChange.getListChanges();
                if (!listChanges.isEmpty()) {
                    for (ListChange listChange : listChanges) {
                        ChangeKind kind = listChange.getKind();
                        int position = listChange.getIndex();
                        EList newObject = listChange.getValues();
                        EList oldList = (EList)eObject.eGet(feature);
                        if (kind == ChangeKind.ADD_LITERAL) {
                            BasicEList newObjectCopy = new BasicEList((Collection)newObject);
                            for (Object object : newObject) {
                                EObject objectinResourceToChange;
                                String id;
                                Resource resource;
                                int index = newObject.indexOf(object);
                                if (!(object instanceof EObject) || (resource = ((EObject)object).eResource()) == null || (id = ((XMIResource)resource).getID((EObject)object)) == null || (objectinResourceToChange = resourceToChange.getEObject(id)) == null) continue;
                                newObjectCopy.set(index, (Object)objectinResourceToChange);
                            }
                            newObject = newObjectCopy;
                            Map<EObject, String> eObjectToIDMap = this.createEObjectToIDMap((EList<Object>)newObject);
                            this.executeADDListChangeCommand(domain, (EList<Object>)oldList, position, (EList<Object>)newObject);
                            if (eObjectToIDMap.isEmpty()) continue;
                            this.setID(eObjectToIDMap);
                            continue;
                        }
                        if (kind == ChangeKind.REMOVE_LITERAL) {
                            this.executeREMOVEListChangeCommand(domain, (EList<Object>)oldList, position);
                            continue;
                        }
                        if (kind != ChangeKind.MOVE_LITERAL) continue;
                        int moveToIndex = listChange.getMoveToIndex();
                        this.executeMOVEListChangeCommand(domain, (EList<Object>)oldList, position, moveToIndex);
                    }
                    continue;
                }
                Object newValue = featureChange.getValue();
                HashMap<EObject, String> eObjectToIDMap = null;
                if (newValue instanceof EObject) {
                    eObjectToIDMap = new HashMap<EObject, String>();
                    this.createEObjectToIDMap((EObject)newValue, eObjectToIDMap);
                }
                this.executeSETCommand(domain, eObject, feature, newValue);
                if (eObjectToIDMap == null || eObjectToIDMap.isEmpty()) continue;
                this.setID(eObjectToIDMap);
            }
        }
        if (!entriesToApplyLater.isEmpty()) {
            if (entriesToApplyLater.size() == objectChangesSize) {
                throw new RepositoryRuntimeException("The elements to modify cannot be resolved");
            }
            this.applyObjectChangeEntries(domain, (EMap<EObject, EList<FeatureChange>>)entriesToApplyLater);
        }
    }

    public void applyChanges(InputStream description, EPackage.Registry registry) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setPackageRegistry(registry);
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
            ChangeDescription changeDescription = (ChangeDescription)this.inputStreamToEObject(description, (ResourceSet)resourceSet);
            EMap objectChanges = changeDescription.getObjectChanges();
            EList resourceChanges = changeDescription.getResourceChanges();
            try {
                this.loadResources((ResourceSet)resourceSet, (EMap<EObject, EList<FeatureChange>>)objectChanges, (EList<ResourceChange>)resourceChanges);
            }
            catch (IOException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
            if (!resourceChanges.isEmpty()) {
                this.applyResourceChanges(domain, (EList<ResourceChange>)resourceChanges);
            }
            if (!objectChanges.isEmpty()) {
                this.applyObjectChangeEntries(domain, (EMap<EObject, EList<FeatureChange>>)objectChanges);
            }
            BasicEList resources = new BasicEList((Collection)resourceSet.getResources());
            resourceSet.getResources().clear();
            for (Resource resource : resources) {
                TransactionUtil.disconnectFromEditingDomain((Resource)resource);
            }
            BasicEList resourcesToCheckin = new BasicEList(this.changedResources);
            this.changedResources.clear();
            this.checkinModelInAnotherThread((EList<Resource>)resourcesToCheckin);
        }
        catch (Exception e) {
            this.modelBusRepositoryCache.clear();
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void loadResources(ResourceSet resourceSet, EMap<EObject, EList<FeatureChange>> objectChanges, EList<ResourceChange> resourceChanges) throws IOException, UnresolvedReferencesException, NonExistingResourceException, RepositoryAuthentificationException {
        for (ResourceChange resourceChange : resourceChanges) {
            URI resourceUri = URI.createURI((String)resourceChange.getResourceURI());
            Resource resource = resourceSet.getResource(resourceUri, false);
            if (resource == null || resource.getContents().isEmpty()) {
                if (resource != null) {
                    resourceSet.getResources().remove((Object)resource);
                    TransactionUtil.disconnectFromEditingDomain((Resource)resource);
                }
                resource = this.modelBusRepositoryCache.getResourceForModelLocation(resourceUri);
                resourceSet.getResources().add((Object)resource);
            }
            if (this.changedResources.contains(resource)) continue;
            this.changedResources.add(resource);
        }
        for (Map.Entry entry : objectChanges) {
            EObject key = (EObject)entry.getKey();
            URI resourceUri = EcoreUtil.getURI((EObject)key).trimFragment();
            Resource resource = resourceSet.getResource(resourceUri, false);
            if (resource == null || resource.getContents().isEmpty()) {
                if (resource != null) {
                    resourceSet.getResources().remove((Object)resource);
                    TransactionUtil.disconnectFromEditingDomain((Resource)resource);
                }
                resource = this.modelBusRepositoryCache.getResourceForModelLocation(resourceUri);
                resourceSet.getResources().add((Object)resource);
            }
            if (!this.changedResources.contains(resource)) {
                this.changedResources.add(resource);
            }
            EcoreUtil.resolve((EObject)key, (Resource)resource);
        }
    }

    private void applyResourceChanges(TransactionalEditingDomain domain, EList<ResourceChange> resourceChanges) {
        for (ResourceChange resourceChange : resourceChanges) {
            String resourceUri = resourceChange.getResourceURI();
            Resource resourceToChange = domain.getResourceSet().getResource(URI.createURI((String)resourceUri), false);
            if (resourceToChange == null) {
                throw new RepositoryRuntimeException();
            }
            EList listChanges = resourceChange.getListChanges();
            for (ListChange listChange : listChanges) {
                ChangeKind kind = listChange.getKind();
                int index = listChange.getIndex();
                EList newObject = listChange.getValues();
                EList oldList = resourceToChange.getContents();
                if (kind == ChangeKind.ADD_LITERAL) {
                    Map<EObject, String> eObjectToIDMap = this.createEObjectToIDMap((EList<Object>)newObject);
                    this.executeADDListChangeCommand(domain, (EList<Object>)oldList, index, (EList<Object>)newObject);
                    if (eObjectToIDMap.isEmpty()) continue;
                    this.setID(eObjectToIDMap);
                    continue;
                }
                if (kind != ChangeKind.REMOVE_LITERAL) continue;
                this.executeREMOVEListChangeCommand(domain, (EList<Object>)oldList, index);
            }
        }
    }

    private void checkinModelInAnotherThread(final EList<Resource> resources) {
        Runnable checkinModel = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Resource resource : resources) {
                    String resourceUri = resource.getURI().toString();
                    if (resourceUri.equals("tempResource")) continue;
                    try {
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            ChangeCommitManager.this.modelBusRepositoryImpl.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, resource, "TODO: implement commit message", null);
                        }
                    }
                    catch (InvalidValueException e) {
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                    catch (ConstraintViolationException e) {
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                    catch (RepositoryAuthentificationException e) {
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                    catch (LockedException e) {
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                    catch (UnresolvedReferencesException e) {
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        this.executorService.execute(checkinModel);
    }

    private EObject inputStreamToEObject(InputStream changeModel, ResourceSet resourceSet) {
        EObject eObject;
        try {
            Resource changeModelTempResource = resourceSet.createResource(URI.createURI((String)"tempResource"));
            changeModelTempResource.load(changeModel, Collections.EMPTY_MAP);
            eObject = (EObject)changeModelTempResource.getContents().get(0);
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return eObject;
    }

    private void setID(Map<EObject, String> eObjectToIDMap) {
        for (Map.Entry<EObject, String> entry : eObjectToIDMap.entrySet()) {
            String idToSet;
            EObject eObject = entry.getKey();
            Resource eObjectResource = eObject.eResource();
            if (!(eObjectResource instanceof XMIResource) || (idToSet = entry.getValue()) == null) continue;
            ((XMIResource)eObjectResource).setID(eObject, idToSet);
        }
    }

    private Map<EObject, String> createEObjectToIDMap(EList<Object> objectsFromChangeDescription) {
        HashMap<EObject, String> eObjectToIDMap = new HashMap<EObject, String>();
        for (Object object : objectsFromChangeDescription) {
            if (!(object instanceof EObject)) continue;
            this.createEObjectToIDMap((EObject)object, eObjectToIDMap);
        }
        return eObjectToIDMap;
    }

    private void createEObjectToIDMap(EObject objectFromChangeDescription, Map<EObject, String> eObjectToIDMap) {
        XMIResource resource = (XMIResource)objectFromChangeDescription.eResource();
        if (resource != null) {
            String id = resource.getID(objectFromChangeDescription);
            if (id != null) {
                eObjectToIDMap.put(objectFromChangeDescription, id);
            }
            TreeIterator it = EcoreUtil.getAllContents((EObject)objectFromChangeDescription, (boolean)true);
            while (it.hasNext()) {
                EObject contentObject = (EObject)it.next();
                id = resource.getID(contentObject);
                if (id == null) continue;
                eObjectToIDMap.put(contentObject, id);
            }
        }
    }

    private void executeSETCommand(TransactionalEditingDomain domain, final EObject eObject, final EStructuralFeature feature, final Object newValue) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                eObject.eSet(feature, newValue);
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeADDListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index, final EList<Object> newValue) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                if (index < 0 || index >= oldList.size()) {
                    oldList.addAll((Collection)newValue);
                } else {
                    oldList.addAll(index, (Collection)newValue);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeREMOVEListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                if (!oldList.isEmpty()) {
                    if (index > -1 && index < oldList.size()) {
                        oldList.remove(index);
                    } else {
                        oldList.remove(oldList.size() - 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeMOVEListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index, final int moveToIndex) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                if (moveToIndex < oldList.size()) {
                    oldList.move(moveToIndex, index);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void deleteModel(URI modelUri, IModelBusSession session) {
        this.modelBusRepositoryCache.clear();
    }

    @Override
    public void updateModel(URI modelUri, IModelBusSession session) {
        if (!"System".equals(session.getValueForKey("username"))) {
            this.modelBusRepositoryCache.clear();
        }
    }

    @Override
    public void commitChangeModelNotification(String messageID, URI modelUri, DataHandler changeModelContent) {
    }
}

