/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.ecore2xml;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLPackage;
import org.eclipse.emf.mapping.ecore2xml.impl.Ecore2XMLRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Ecore2XMLRegistry
extends Map<String, Object> {
    public static final Ecore2XMLRegistry INSTANCE = new Ecore2XMLRegistryImpl();

    public XMLResource.XMLMap getXMLMap(String var1);

    public static interface Descriptor {
        public XMLResource.XMLMap getXMLMap();
    }

    public static class Reader {
        protected static final String TAG_ECORE2XML = "ecore2xml";
        protected static final String ATT_URI = "uri";
        protected static final String ATT_XMLMAP = "xmlmap";
        private final IExtensionRegistry extensionRegistry;
        private final String namespace;
        private final String extensionPointID;

        public Reader(IExtensionRegistry extensionRegistry, String namespace, String extensionPointID) {
            this.extensionRegistry = extensionRegistry;
            this.namespace = namespace;
            this.extensionPointID = extensionPointID;
        }

        protected void readElement(IConfigurationElement element) {
            String uri;
            if (TAG_ECORE2XML.equals(element.getName()) && (uri = element.getAttribute(ATT_URI)) != null && element.getAttribute(ATT_XMLMAP) != null) {
                INSTANCE.put(uri, new Ecore2XMLDescriptor(element));
            }
        }

        public void readRegistry() {
            IExtensionPoint extensionPoint = this.extensionRegistry.getExtensionPoint(this.namespace, this.extensionPointID);
            if (extensionPoint != null) {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.readElement(elements[i]);
                    ++i;
                }
            }
        }

        protected static class Ecore2XMLDescriptor
        implements Descriptor {
            private final IConfigurationElement element;
            private XMLResource.XMLMap xmlMap = null;

            protected Ecore2XMLDescriptor(IConfigurationElement element) {
                this.element = element;
            }

            public XMLResource.XMLMap getXMLMap() {
                if (this.xmlMap == null) {
                    try {
                        this.xmlMap = (XMLResource.XMLMap)EcoreUtil.getObjectByType((Collection)new ResourceSetImpl().getResource(URI.createURI((String)this.element.getAttribute(Reader.ATT_XMLMAP)), true).getContents(), (EClassifier)Ecore2XMLPackage.eINSTANCE.getXMLMap());
                    }
                    catch (Exception e) {
                        throw new WrappedException(e);
                    }
                }
                return this.xmlMap;
            }
        }
    }
}

