/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesComponent
extends DefaultComponent {
    public static final String DEFAULT_PREFIX_TOKEN = "{{";
    public static final String DEFAULT_SUFFIX_TOKEN = "}}";
    public static final String PREFIX_TOKEN = "{{";
    public static final String SUFFIX_TOKEN = "}}";
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env:(.*?)\\}", 32);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$\\{(.*?)\\}", 32);
    private static final transient Logger LOG = LoggerFactory.getLogger(PropertiesComponent.class);
    private final Map<CacheKey, Properties> cacheMap = new LRUSoftCache<CacheKey, Properties>(1000);
    private PropertiesResolver propertiesResolver = new DefaultPropertiesResolver();
    private PropertiesParser propertiesParser = new DefaultPropertiesParser();
    private String[] locations;
    private boolean cache = true;
    private String propertyPrefix;
    private String propertySuffix;
    private boolean fallbackToUnaugmentedProperty = true;
    private String prefixToken = "{{";
    private String suffixToken = "}}";

    public PropertiesComponent() {
    }

    public PropertiesComponent(String location) {
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this.setLocations(locations);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] paths = this.locations;
        String locations = this.getAndRemoveParameter(parameters, "locations", String.class);
        if (locations != null) {
            LOG.trace("Overriding default locations with location: {}", (Object)locations);
            paths = locations.split(",");
        }
        String endpointUri = this.parseUri(remaining, paths);
        LOG.debug("Endpoint uri parsed as: {}", (Object)endpointUri);
        return this.getCamelContext().getEndpoint(endpointUri);
    }

    public String parseUri(String uri) throws Exception {
        return this.parseUri(uri, this.locations);
    }

    public String parseUri(String uri, String ... paths) throws Exception {
        Properties prop = null;
        if (paths != null) {
            String[] locations = this.parseLocations(paths);
            CacheKey key = new CacheKey(locations);
            Properties properties = prop = this.cache ? this.cacheMap.get(key) : null;
            if (prop == null) {
                prop = this.propertiesResolver.resolveProperties(this.getCamelContext(), locations);
                if (this.cache) {
                    this.cacheMap.put(key, prop);
                }
            }
        }
        if (!uri.contains(this.prefixToken) && !uri.startsWith(this.prefixToken)) {
            uri = this.prefixToken + uri;
        }
        if (!uri.contains(this.suffixToken) && !uri.endsWith(this.suffixToken)) {
            uri = uri + this.suffixToken;
        }
        LOG.trace("Parsing uri {} with properties: {}", (Object)uri, prop);
        if (this.propertiesParser instanceof AugmentedPropertyNameAwarePropertiesParser) {
            return ((AugmentedPropertyNameAwarePropertiesParser)this.propertiesParser).parseUri(uri, prop, this.prefixToken, this.suffixToken, this.propertyPrefix, this.propertySuffix, this.fallbackToUnaugmentedProperty);
        }
        return this.propertiesParser.parseUri(uri, prop, this.prefixToken, this.suffixToken);
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public void setLocation(String location) {
        this.setLocations(location.split(","));
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public String getPropertySuffix() {
        return this.propertySuffix;
    }

    public void setPropertySuffix(String propertySuffix) {
        this.propertySuffix = propertySuffix;
    }

    public boolean isFallbackToUnaugmentedProperty() {
        return this.fallbackToUnaugmentedProperty;
    }

    public void setFallbackToUnaugmentedProperty(boolean fallbackToUnaugmentedProperty) {
        this.fallbackToUnaugmentedProperty = fallbackToUnaugmentedProperty;
    }

    public String getPrefixToken() {
        return this.prefixToken;
    }

    public void setPrefixToken(String prefixToken) {
        this.prefixToken = prefixToken == null ? "{{" : prefixToken;
    }

    public String getSuffixToken() {
        return this.suffixToken;
    }

    public void setSuffixToken(String suffixToken) {
        this.suffixToken = suffixToken == null ? "}}" : suffixToken;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.cacheMap);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.cacheMap);
        super.doStop();
    }

    private String[] parseLocations(String[] locations) {
        String[] answer = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            String value;
            String key;
            String location = locations[i];
            LOG.trace("Parsing location: {} ", (Object)location);
            Matcher matcher = ENV_PATTERN.matcher(location);
            while (matcher.find()) {
                key = matcher.group(1);
                value = System.getenv(key);
                if (ObjectHelper.isEmpty(value)) {
                    throw new IllegalArgumentException("Cannot find system environment with key: " + key);
                }
                value = Matcher.quoteReplacement(value);
                location = matcher.replaceFirst(value);
                matcher = ENV_PATTERN.matcher(location);
            }
            matcher = SYS_PATTERN.matcher(location);
            while (matcher.find()) {
                key = matcher.group(1);
                value = System.getProperty(key);
                if (ObjectHelper.isEmpty(value)) {
                    throw new IllegalArgumentException("Cannot find JVM system property with key: " + key);
                }
                value = Matcher.quoteReplacement(value);
                location = matcher.replaceFirst(value);
                matcher = SYS_PATTERN.matcher(location);
            }
            LOG.debug("Parsed location: {} ", (Object)location);
            answer[i] = location;
        }
        return answer;
    }

    private static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String[] locations;

        private CacheKey(String[] locations) {
            this.locations = locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Arrays.equals(this.locations, that.locations);
        }

        public int hashCode() {
            return this.locations != null ? Arrays.hashCode(this.locations) : 0;
        }

        public String toString() {
            return "LocationKey[" + Arrays.asList(this.locations).toString() + "]";
        }
    }
}

