/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.types;

import org.apache.camel.language.simple.types.TokenType;

public class SimpleTokenType {
    private final TokenType type;
    private final String value;

    public SimpleTokenType(TokenType type, String value) {
        this.type = type;
        this.value = value;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isWhitespace() {
        return this.type == TokenType.whiteSpace;
    }

    public boolean isEol() {
        return this.type == TokenType.eol;
    }

    public boolean isSingleQuote() {
        return this.type == TokenType.singleQuote;
    }

    public boolean isDoubleQuote() {
        return this.type == TokenType.doubleQuote;
    }

    public boolean isFunctionStart() {
        return this.type == TokenType.functionStart;
    }

    public boolean isFunctionEnd() {
        return this.type == TokenType.functionEnd;
    }

    public boolean isBinary() {
        return this.type == TokenType.binaryOperator;
    }

    public boolean isUnary() {
        return this.type == TokenType.unaryOperator;
    }

    public boolean isLogical() {
        return this.type == TokenType.logicalOperator;
    }

    public boolean isNullValue() {
        return this.type == TokenType.nullValue;
    }

    public String toString() {
        return this.value;
    }
}

