/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.export;

import java.util.HashMap;
import java.util.Map;
import org.modelbus.desktop.export.JobDescriptor;

public class JobRegistry {
    private static JobRegistry _instance;
    private Map<Integer, JobDescriptor> jobs = new HashMap<Integer, JobDescriptor>();

    private JobRegistry() {
    }

    public static synchronized JobRegistry getInstance() {
        if (_instance == null) {
            _instance = new JobRegistry();
        }
        return _instance;
    }

    public int addJob(JobDescriptor job) {
        Integer jobID = this.jobs.size() + 1;
        job.setID(jobID);
        this.jobs.put(jobID, job);
        return jobID;
    }

    public JobDescriptor getJob(Integer id) {
        if (this.jobs.containsKey(id)) {
            return this.jobs.get(id);
        }
        return null;
    }

    public void releaseJob(Integer id) {
        if (this.jobs.containsKey(id)) {
            this.jobs.remove(id);
        }
    }
}

