/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.svn;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.impl.ModelBusDirEntryImpl;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNNodeKind;

public class ModelBusSvnDirEntry
extends ModelBusDirEntryImpl {
    public ModelBusSvnDirEntry(SVNDirEntry dirEntry, String svnRepositoryLocation) throws MalformedURLException {
        this.name = dirEntry.getName();
        this.kind = ModelBusSvnDirEntry.convertSVNNodeKindToModelBusNodeKind(dirEntry.getKind());
        this.size = dirEntry.getSize();
        this.revision = String.valueOf(dirEntry.getRevision());
        this.creationDate = dirEntry.getDate();
        this.lastAuthor = dirEntry.getAuthor();
        this.commitMessage = dirEntry.getCommitMessage();
        this.url = ModelBusSvnDirEntry.convertSVNURLtoModelBusURL((String)dirEntry.getURL().toString(), (String)svnRepositoryLocation);
    }

    public static ModelBusNodeKind convertSVNNodeKindToModelBusNodeKind(SVNNodeKind svnNodeKind) {
        if (SVNNodeKind.DIR.compareTo((Object)svnNodeKind) == 0) {
            return ModelBusNodeKind.DIR;
        }
        if (SVNNodeKind.FILE.compareTo((Object)svnNodeKind) == 0) {
            return ModelBusNodeKind.FILE;
        }
        return ModelBusNodeKind.UNKNOWN;
    }

    public static void convertSVNDirEntryCollectionToModelBusDirEntryCollectionDestructive(Collection<IModelBusDirEntry> collection, String svnRepositoryLocation) throws MalformedURLException {
        ArrayList<ModelBusSvnDirEntry> list = new ArrayList<ModelBusSvnDirEntry>();
        Iterator<IModelBusDirEntry> iterator = collection.iterator();
        while (iterator.hasNext()) {
            SVNDirEntry currentSVNDirEntry = (SVNDirEntry)iterator.next();
            ModelBusSvnDirEntry entry = new ModelBusSvnDirEntry(currentSVNDirEntry, svnRepositoryLocation);
            list.add(entry);
            iterator.remove();
        }
        collection.addAll(list);
    }
}

