/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.impl.DefaultThreadPoolFactory;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutorServiceManager
extends ServiceSupport
implements ExecutorServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutorServiceManager.class);
    private final CamelContext camelContext;
    private ThreadPoolFactory threadPoolFactory = new DefaultThreadPoolFactory();
    private final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private String threadNamePattern;
    private String defaultThreadPoolProfileId = "defaultThreadPoolProfile";
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new HashMap<String, ThreadPoolProfile>();
    private ThreadPoolProfile builtIndefaultProfile;

    public DefaultExecutorServiceManager(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.builtIndefaultProfile = new ThreadPoolProfile(this.defaultThreadPoolProfileId);
        this.builtIndefaultProfile.setDefaultProfile(true);
        this.builtIndefaultProfile.setPoolSize(10);
        this.builtIndefaultProfile.setMaxPoolSize(20);
        this.builtIndefaultProfile.setKeepAliveTime(60L);
        this.builtIndefaultProfile.setTimeUnit(TimeUnit.SECONDS);
        this.builtIndefaultProfile.setMaxQueueSize(1000);
        this.builtIndefaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(this.builtIndefaultProfile);
    }

    @Override
    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public void setThreadPoolFactory(ThreadPoolFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
    }

    @Override
    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        ObjectHelper.notNull(profile, "profile");
        ObjectHelper.notEmpty(profile.getId(), "id", profile);
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    @Override
    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    @Override
    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        defaultThreadPoolProfile.addDefaults(this.builtIndefaultProfile);
        LOG.info("Using custom DefaultThreadPoolProfile: " + defaultThreadPoolProfile);
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(true);
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    @Override
    public void setThreadNamePattern(String threadNamePattern) {
        String name;
        this.threadNamePattern = name = threadNamePattern.replaceFirst("\\$\\{camelId\\}", this.camelContext.getName());
    }

    @Override
    public String resolveThreadName(String name) {
        return ThreadHelper.resolveThreadName(this.threadNamePattern, name);
    }

    @Override
    public ExecutorService newDefaultThreadPool(Object source, String name) {
        return this.newThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ScheduledExecutorService newDefaultScheduledThreadPool(Object source, String name) {
        return this.newScheduledThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newThreadPool(source, name, profile);
        }
        return null;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ObjectHelper.notNull(profile, "ThreadPoolProfile");
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        profile.addDefaults(defaultProfile);
        ThreadFactory threadFactory = this.createThreadFactory(sanitizedName, true);
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(profile, threadFactory);
        this.onThreadPoolCreated(executorService, source, profile.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, executorService});
        }
        return executorService;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int poolSize, int maxPoolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(maxPoolSize);
        return this.newThreadPool(source, name, profile);
    }

    @Override
    public ExecutorService newSingleThreadExecutor(Object source, String name) {
        return this.newFixedThreadPool(source, name, 1);
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source, String name) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ExecutorService answer = this.threadPoolFactory.newCachedThreadPool(this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new CachedThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(poolSize);
        profile.setKeepAliveTime(0L);
        return this.newThreadPool(source, name, profile);
    }

    @Override
    public ScheduledExecutorService newSingleThreadScheduledExecutor(Object source, String name) {
        return this.newScheduledThreadPool(source, name, 1);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        profile.addDefaults(this.getDefaultThreadPoolProfile());
        ScheduledExecutorService answer = this.threadPoolFactory.newScheduledThreadPool(profile, this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ScheduledThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newScheduledThreadPool(source, name, profile);
        }
        return null;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        return this.newScheduledThreadPool(source, name, profile);
    }

    @Override
    public void shutdown(ExecutorService executorService) {
        ObjectHelper.notNull(executorService, "executorService");
        if (executorService.isShutdown()) {
            return;
        }
        LOG.debug("Shutdown ExecutorService: {}", (Object)executorService);
        executorService.shutdown();
        LOG.trace("Shutdown ExecutorService: {} complete.", (Object)executorService);
        this.executorServices.remove(executorService);
    }

    @Override
    public List<Runnable> shutdownNow(ExecutorService executorService) {
        return this.doShutdownNow(executorService, true);
    }

    private List<Runnable> doShutdownNow(ExecutorService executorService, boolean remove) {
        ObjectHelper.notNull(executorService, "executorService");
        if (executorService.isShutdown()) {
            return null;
        }
        LOG.debug("ShutdownNow ExecutorService: {}", (Object)executorService);
        List<Runnable> answer = executorService.shutdownNow();
        LOG.trace("ShutdownNow ExecutorService: {} complete.", (Object)executorService);
        if (remove) {
            this.executorServices.remove(executorService);
        }
        return answer;
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.threadNamePattern == null) {
            this.threadNamePattern = "Camel (" + this.camelContext.getName() + ") thread #${counter} - ${name}";
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        for (ExecutorService executorService : this.executorServices) {
            try {
                this.doShutdownNow(executorService, false);
            }
            catch (Throwable e) {
                LOG.warn("Error occurred during shutdown of ExecutorService: " + executorService + ". This exception will be ignored.", e);
            }
        }
        this.executorServices.clear();
        Iterator<ThreadPoolProfile> it = this.threadPoolProfiles.values().iterator();
        while (it.hasNext()) {
            ThreadPoolProfile profile = it.next();
            if (profile.isDefaultProfile().booleanValue()) continue;
            it.remove();
        }
    }

    private void onThreadPoolCreated(ExecutorService executorService, Object source, String threadPoolProfileId) {
        RouteDefinition route;
        String id;
        this.executorServices.add(executorService);
        String sourceId = null;
        String routeId = null;
        if (source instanceof NamedNode) {
            id = ((OptionalIdentifiedDefinition)source).idOrCreate(this.camelContext.getNodeIdFactory());
            sourceId = ((NamedNode)source).getShortName();
        } else {
            id = source instanceof String ? (String)source : (source != null ? source.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(source) + ")" : executorService.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(executorService) + ")");
        }
        ObjectHelper.notEmpty(id, "id for thread pool " + executorService);
        if (source instanceof ProcessorDefinition && (route = ProcessorDefinitionHelper.getRoute((ProcessorDefinition)source)) != null) {
            routeId = route.idOrCreate(this.camelContext.getNodeIdFactory());
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            threadPool = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            threadPool = ((SizedScheduledExecutorService)executorService).getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
            }
        }
        this.onNewExecutorService(executorService);
    }

    private ThreadFactory createThreadFactory(String name, boolean isDaemon) {
        CamelThreadFactory threadFactory = new CamelThreadFactory(this.threadNamePattern, name, isDaemon);
        return threadFactory;
    }
}

