/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;

public final class ThreadPoolBuilder {
    private final ThreadPoolProfile profile;
    private final CamelContext context;

    public ThreadPoolBuilder(CamelContext context) {
        this.context = context;
        this.profile = new ThreadPoolProfile();
    }

    public ThreadPoolBuilder poolSize(int poolSize) {
        this.profile.setPoolSize(poolSize);
        return this;
    }

    public ThreadPoolBuilder maxPoolSize(int maxPoolSize) {
        this.profile.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.profile.setKeepAliveTime(keepAliveTime);
        this.profile.setTimeUnit(timeUnit);
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        this.profile.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolBuilder maxQueueSize(int maxQueueSize) {
        this.profile.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadPoolBuilder rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.profile.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ExecutorService build() throws Exception {
        return this.build(null, null);
    }

    public ExecutorService build(String name) throws Exception {
        return this.build(null, name);
    }

    public ExecutorService build(Object source, String name) throws Exception {
        return this.context.getExecutorServiceManager().newThreadPool(source, name, this.profile);
    }
}

