/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ConfigurationHelper;

public abstract class DefaultEndpointConfiguration
implements EndpointConfiguration {
    private Component component;
    private URI uri;

    public DefaultEndpointConfiguration(Component component) {
        this.component = component;
    }

    public DefaultEndpointConfiguration(Component component, String uri) {
        this(component);
        try {
            this.setURI(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.parseURI();
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public <T> T getParameter(String name) {
        return (T)ConfigurationHelper.getConfigurationParameter((EndpointConfiguration)this, name);
    }

    @Override
    public <T> void setParameter(String name, T value) {
        ConfigurationHelper.setConfigurationField(this, name, value);
    }

    @Override
    public String toUriString(EndpointConfiguration.UriFormat format) {
        return ConfigurationHelper.formatConfigurationUri(this, format);
    }

    protected Component getComponent() {
        return this.component;
    }

    protected void parseURI() {
        ConfigurationHelper.populateFromURI(this, new ConfigurationHelper.FieldParameterSetter());
    }
}

