/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.status.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.desktop.Activator;
import org.modelbus.desktop.status.ModelBusStatusProvider;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.dosgi.repository.descriptor.ServiceStatus;

public class StatusView
extends ViewPart
implements Observer {
    public static final String ID = "org.modelbus.desktop.statusView";
    private static final String MON_ICON_PATH = "/icons/status/monitor_view.gif";
    private static final String NOT_AVAILABLE_LABEL = "n/a";
    private Label locationLabel;
    private Label startupLabel;
    private Composite parent;
    private TableViewer servicesTableViewer;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData fillHorizontalData = new GridData();
        fillHorizontalData.grabExcessHorizontalSpace = true;
        fillHorizontalData.horizontalAlignment = 4;
        Label startupLabelCaption = new Label(parent, 0);
        startupLabelCaption.setText("Startup time:");
        this.startupLabel = new Label(parent, 0);
        this.startupLabel.setLayoutData((Object)fillHorizontalData);
        Label locationLabelCaption = new Label(parent, 0);
        locationLabelCaption.setText("Repository service location:");
        this.locationLabel = new Label(parent, 0);
        this.locationLabel.setLayoutData((Object)fillHorizontalData);
        Label servicesLabel = new Label(parent, 0);
        servicesLabel.setText("Registered ModelBus services:");
        GridData fillHorizontal3ColumnsData = new GridData();
        fillHorizontal3ColumnsData.grabExcessHorizontalSpace = true;
        fillHorizontal3ColumnsData.horizontalAlignment = 4;
        fillHorizontal3ColumnsData.horizontalSpan = 2;
        servicesLabel.setLayoutData((Object)fillHorizontal3ColumnsData);
        this.servicesTableViewer = new TableViewer(parent, 66306);
        String[] titles = new String[]{"Name", "Location", "Startup"};
        int[] bounds = new int[]{200, 350, 200};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(this.servicesTableViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setWidth(bounds[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        Table table = this.servicesTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                Table t = (Table)e.getSource();
                int index = t.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                List<ServiceStatus> serviceStatus = ModelBusDesktopUtil.getInstance().getStatus().getServices();
                if (serviceStatus.isEmpty()) {
                    return;
                }
                if (index > serviceStatus.size() - 1) {
                    return;
                }
                ServiceStatus status = ModelBusDesktopUtil.getInstance().getStatus().getServices().get(index);
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(String.valueOf(status.getLocation()) + "?wsdl"));
                }
                catch (PartInitException e1) {
                    throw new RuntimeException(e1);
                }
                catch (MalformedURLException e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
        this.servicesTableViewer.setLabelProvider((IBaseLabelProvider)new ServiceStatusLabelProvider());
        this.servicesTableViewer.setContentProvider((IContentProvider)new ServiceStatusContentProvider());
        GridData tableViewerLData = new GridData();
        tableViewerLData.horizontalAlignment = 4;
        tableViewerLData.verticalAlignment = 4;
        tableViewerLData.grabExcessHorizontalSpace = true;
        tableViewerLData.grabExcessVerticalSpace = true;
        tableViewerLData.horizontalSpan = 2;
        this.servicesTableViewer.getControl().setLayoutData((Object)tableViewerLData);
        ModelBusDesktopUtil.getInstance().getStatus().addObserver(this, true);
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.parent == null || this.parent.isDisposed()) {
            return;
        }
        this.parent.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ModelBusStatusProvider status = ModelBusDesktopUtil.getInstance().getStatus();
                String dateString = null;
                if (status.getRepositoryStartup() != -1L) {
                    Date date = new Date(status.getRepositoryStartup());
                    dateString = ModelBusStatusProvider.DATE_FORMAT.format(date);
                } else {
                    dateString = StatusView.NOT_AVAILABLE_LABEL;
                }
                StatusView.this.startupLabel.setText(dateString);
                if (status.getRepositoryLocation() != null) {
                    StatusView.this.locationLabel.setText(AbstractLocationsUtil.getExternalLocation((String)status.getRepositoryLocation()));
                } else {
                    StatusView.this.locationLabel.setText(StatusView.NOT_AVAILABLE_LABEL);
                }
                StatusView.this.servicesTableViewer.setInput(status.getServices());
                StatusView.this.servicesTableViewer.refresh();
            }
        });
    }

    class ServiceStatusContentProvider
    implements IStructuredContentProvider {
        private List<ServiceStatus> services;

        ServiceStatusContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.services == null) {
                return new ServiceStatus[0];
            }
            return this.services.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.services = (List)newInput;
        }
    }

    class ServiceStatusLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private int index;

        ServiceStatusLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return Activator.getImageDescriptor(StatusView.MON_ICON_PATH).createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            this.index = columnIndex;
            ServiceStatus serviceStatus = (ServiceStatus)element;
            switch (columnIndex) {
                case 0: {
                    return serviceStatus.getName();
                }
                case 1: {
                    return serviceStatus.getLocation();
                }
                case 2: {
                    return ModelBusStatusProvider.DATE_FORMAT.format(serviceStatus.getStartupDate().toGregorianCalendar().getTime());
                }
            }
            return "?";
        }

        public Color getForeground(Object element) {
            if (this.index == 0) {
                return null;
            }
            if (this.index == 1) {
                return Display.getCurrent().getSystemColor(9);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

