/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.merge;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelbus.tools.diffmerge.merge.AbstractDiffModelElementMerger;
import org.modelbus.tools.diffmerge.merge.BasicMerger;
import org.modelbus.tools.diffmerge.merge.ChangesTracker;
import org.modelbus.tools.diffmerge.merge.ElementAlreadyMergedEvent;
import org.modelbus.tools.diffmerge.merge.Merger;
import org.modelbus.tools.diffmerge.merge.NonConflictMerger;
import org.modelbus.tools.diffmerge.merge.ResourceChangesTracker;
import org.modelbus.tools.diffmerge.merge.ResourceSetChangesTracker;
import org.modelbus.tools.diffmerge.model.AbstractDiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge2.joint.SimpleParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class MergerImpl
extends SimpleParticipant
implements Merger {
    private final BasicMerger basicMerger;
    private final NonConflictMerger nonConflictMerger;
    private ChangesTracker tracker;
    private DiffModel model;
    private final Set<Object> eventHandlers = Sets.newHashSet();

    public MergerImpl(ModelBusEventBus eventBus) {
        super(eventBus);
        this.basicMerger = new BasicMerger();
        this.nonConflictMerger = new NonConflictMerger();
        this.initEventHandlers();
    }

    private void initEventHandlers() {
        this.eventHandlers.add(this.basicMerger);
        this.eventHandlers.add(this.nonConflictMerger);
    }

    protected ChangesTracker createChangesTracker(DiffModel model) {
        ChangesTracker tracker;
        Notifier leftSide = model.getLeftSide();
        if (leftSide instanceof ResourceSet) {
            tracker = new ResourceSetChangesTracker((ResourceSet)leftSide, (ResourceSet)model.getRightSide());
        } else if (leftSide instanceof Resource) {
            tracker = new ResourceChangesTracker((Resource)leftSide, (Resource)model.getRightSide());
        } else {
            throw new RuntimeException(String.format("Unsupported source: %s", leftSide.getClass().getName()));
        }
        return tracker;
    }

    @Override
    public Optional<DiffModel> mergeFromRightToLeft(DiffModelElement element, boolean ignoreConflicts) {
        if (!this.elementIsInModel(element)) {
            return Optional.absent();
        }
        this.tracker.startTracking();
        AbstractDiffModelElementMerger merger = this.getMergerForConflictHandling(ignoreConflicts);
        DiffModel model = merger.mergeFromRightToLeft(element);
        this.tracker.stopTracking();
        this.getEventBus().post((Object)new ElementAlreadyMergedEvent(ElementAlreadyMergedEvent.Direction.LEFT, this.tracker.getChangedResources()));
        return Optional.of((Object)model);
    }

    private AbstractDiffModelElementMerger getMergerForConflictHandling(boolean ignoreConflicts) {
        if (ignoreConflicts) {
            return this.basicMerger;
        }
        return this.nonConflictMerger;
    }

    private boolean elementIsInModel(DiffModelElement element) {
        if (element.equals(this.getDiffModel())) {
            return true;
        }
        if (element instanceof AbstractDiffElement) {
            return this.getDiffModel().getAllDiffElements().contains((Object)element);
        }
        return this.getDiffModel().getAllSubElements().contains(element);
    }

    @Override
    public Optional<DiffModel> mergeFromLeftToRight(DiffModelElement element, boolean ignoreConflicts) {
        if (!this.elementIsInModel(element)) {
            return Optional.absent();
        }
        this.tracker.startTracking();
        AbstractDiffModelElementMerger merger = this.getMergerForConflictHandling(ignoreConflicts);
        DiffModel model = merger.mergeFromLeftToRight(element);
        this.tracker.stopTracking();
        this.getEventBus().post((Object)new ElementAlreadyMergedEvent(ElementAlreadyMergedEvent.Direction.RIGHT, this.tracker.getChangedResources()));
        return Optional.of((Object)model);
    }

    @Override
    public void setDiffModel(DiffModel model) {
        this.model = model;
        this.tracker = this.createChangesTracker(model);
        this.basicMerger.setModel(model);
        this.nonConflictMerger.setModel(model);
    }

    private DiffModel getDiffModel() {
        return (DiffModel)Preconditions.checkNotNull((Object)this.model, (Object)"No model set!!!");
    }

    public Collection<Object> getAllEventHandlers() {
        return this.eventHandlers;
    }
}

