/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementLeaf;
import org.modelbus.tools.diffmerge.model.DiffModelException;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;

public class DiffElementCollection
implements DiffCollection<DiffElement> {
    private final LinkedList<DiffElement> elements = Lists.newLinkedList();

    static DiffCollection<DiffElement> createNewCollection() {
        return new DiffElementCollection();
    }

    static DiffCollection<DiffElement> createNewCollection(Collection<DiffElement> elements) {
        DiffElementCollection collection = new DiffElementCollection();
        collection.elements.addAll(elements);
        return collection;
    }

    private DiffElementCollection() {
    }

    public Iterator<DiffElement> iterator() {
        return this.elements.iterator();
    }

    public DiffElement get(int index) {
        return this.elements.get(index);
    }

    public boolean add(DiffElement ... e) {
        ArrayList tmp = Lists.newArrayList((Object[])e);
        return this.elements.addAll(tmp);
    }

    public DiffElement remove(int index) {
        return this.elements.remove(index);
    }

    public int indexOf(Object e) {
        int idx = this.elements.indexOf(e);
        if (idx < 0 && e instanceof DiffElementLeaf) {
            DiffElement parent = ((DiffElementLeaf)e).getParent();
            idx = this.elements.indexOf(parent);
        }
        return idx;
    }

    public boolean remove(Object e) {
        int idx = this.indexOf(e);
        DiffElement element = null;
        if (idx >= 0) {
            element = this.remove(idx);
        }
        return element != null;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    public void clear() {
        this.elements.clear();
    }

    public List<DiffElement> toList() {
        return ImmutableList.copyOf(this.elements);
    }

    public boolean add(DiffCollection<DiffElement> collection) {
        List list = collection.toList();
        return this.elements.addAll(list);
    }

    public DiffElement[] toArray() {
        return this.elements.toArray(new DiffElement[this.elements.size()]);
    }

    public DiffElement getFirst() {
        this.checkForEmptyCollection();
        return this.elements.getFirst();
    }

    private void checkForEmptyCollection() {
        if (this.elements.isEmpty()) {
            throw new DiffModelException("This collection is empty");
        }
    }

    public DiffElement getLast() {
        this.checkForEmptyCollection();
        return this.elements.getLast();
    }

    public boolean contains(Object e) {
        return this.indexOf(e) >= 0;
    }
}

