/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.user;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.desktop.Activator;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.user.UserModelEditor;
import org.modelbus.desktop.user.UserModelEditorInput;
import org.modelbus.desktop.user.UserModelProvider;
import org.modelbus.desktop.user.UserTreeViewLabelProvider;
import org.modelbus.desktop.user.UsersViewTreeFactory;
import org.modelbus.desktop.user.UsersViewTreeStructureAdvisor;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.model.user.NamedElement;
import org.modelbus.model.user.User;
import org.modelbus.model.user.UserModel;
import org.modelbus.model.user.UserPackage;

public class UsersView
extends ViewPart
implements Observer {
    public static final String ID = "org.modelbus.desktop.usersview";
    private TreeViewer usersViewer;
    private Shell shell;

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        this.usersViewer = new TreeViewer(parent);
        UsersViewTreeFactory treeFactory = new UsersViewTreeFactory();
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)treeFactory, (TreeStructureAdvisor)new UsersViewTreeStructureAdvisor());
        this.usersViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableSet knownElements = contentProvider.getKnownElements();
        IObservableMap[] map = new IObservableMap[]{EMFProperties.value((EStructuralFeature)UserPackage.Literals.USER_MODEL__OWNED_USER).observeDetail(knownElements), EMFProperties.value((EStructuralFeature)UserPackage.Literals.USER_MODEL__OWNED_USER_GROUP).observeDetail(knownElements), EMFProperties.value((EStructuralFeature)UserPackage.Literals.NAMED_ELEMENT__NAME).observeDetail(knownElements)};
        this.usersViewer.setLabelProvider((IBaseLabelProvider)new UserTreeViewLabelProvider(map));
        this.usersViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof User) {
                    User user = (User)element;
                    if (parentElement instanceof UserModel && !user.getUsergroups().isEmpty()) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.usersViewer.setInput((Object)UserModelProvider.getUserModel());
        this.usersViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object obj;
                if (UserSessionHelper.getInstance().getSession() == null) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof NamedElement) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart editor = page.openEditor((IEditorInput)new UserModelEditorInput(UserModelProvider.getUserModel()), "org.modelbus.desktop.UserEditor");
                        if (editor instanceof UserModelEditor) {
                            UserModelEditor userEditor = (UserModelEditor)editor;
                            userEditor.setUserModelElement((NamedElement)obj);
                        }
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        Action action = new Action("Refresh"){

            public void run() {
                UsersView.this.update(null, null);
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("icons/common/refresh.gif"));
        action.setToolTipText("Refresh");
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
        this.wireContextMenu();
        ModelBusDesktopUtil.getInstance().getStatus().addObserver(this, true);
    }

    private void wireContextMenu() {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("mgt"));
        Menu menu = manager.createContextMenu(this.usersViewer.getControl());
        this.usersViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.usersViewer);
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UsersView.this.usersViewer.setInput((Object)UserModelProvider.getUserModel());
                UsersView.this.usersViewer.refresh();
            }
        });
    }

    public void refresh() {
        this.usersViewer.refresh();
    }
}

