/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui;

import java.util.Collection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.tools.diffmerge.model.identifier.DefaultIdentifier;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.diffmerge.ui.DiffMergeViewImpl;
import org.modelbus.tools.diffmerge.ui.IconProviderQueue;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.config.UIConfigImpl;
import org.modelbus.tools.diffmerge.ui.icon.EcoreIconProvider;
import org.modelbus.tools.diffmerge.ui.properties.AttributeEditingSupport;
import org.modelbus.tools.diffmerge.ui.properties.EStructuralFeaturePropertyElement;
import org.modelbus.tools.diffmerge.ui.properties.PropertiesViewEventHandler;
import org.modelbus.tools.diffmerge.ui.util.GuiHelperUtil;
import org.modelbus.tools.modelbusexplorer.blackboard.EventBusProvider;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.properties.editing.PropertyElementEditingSupportBuilder;

public final class DiffMergeViewBuilder {
    private UIConfig config;
    private final ModelBusEventBus eventBus;
    private ModelIdentifier supporter;
    private final IconProviderQueue iconProvider;

    public static DiffMergeViewBuilder createNewBuilder() {
        return new DiffMergeViewBuilder();
    }

    private DiffMergeViewBuilder() {
        PropertyElementEditingSupportBuilder.getInstance().registerNewEditingSupport(EStructuralFeaturePropertyElement.class, AttributeEditingSupport.class);
        this.supporter = new DefaultIdentifier();
        this.eventBus = EventBusProvider.getRunningEventBusInstance();
        this.iconProvider = new IconProviderQueue();
        UIConfigImpl uiConfig = new UIConfigImpl();
        this.setUIConfig(uiConfig);
    }

    public DiffMergeView createNewStandAloneView() {
        return this.createNewStandAloneView(800, 600);
    }

    public DiffMergeView createNewStandAloneView(int width, int height) {
        Display display = Display.getDefault();
        Shell parent = new Shell(display);
        parent.setSize(width, height);
        parent.setLayout((Layout)new FillLayout());
        return this.createViewForParent((Composite)parent, 0);
    }

    public DiffMergeView createViewForParent(Composite parent, int style) {
        GuiHelperUtil guiUtil = new GuiHelperUtil(parent.getDisplay(), this.config);
        final DiffMergeViewImpl view = new DiffMergeViewImpl(parent, style, this.config, this.eventBus, guiUtil, this.supporter);
        parent.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DiffMergeViewBuilder.this.unregisterEventHandlers(view.getAllEventHandlers());
            }
        });
        Collection allEventHandlers = view.getAllEventHandlers();
        PropertiesViewEventHandler propertiesViewEventHandler = new PropertiesViewEventHandler(this.eventBus);
        allEventHandlers.add(propertiesViewEventHandler);
        this.registerEventHandlers(allEventHandlers);
        return view;
    }

    private void addDefaultIconProvider(Display display) {
        this.iconProvider.addIconProivder(new EcoreIconProvider(display));
    }

    private void registerEventHandlers(Collection<? extends Object> eventHandlers) {
        for (Object object : eventHandlers) {
            this.eventBus.register(object);
        }
    }

    private void unregisterEventHandlers(Collection<? extends Object> eventHandlers) {
        for (Object object : eventHandlers) {
            this.eventBus.unregister(object);
        }
    }

    public DiffMergeViewBuilder setUIConfig(UIConfig config) {
        if (this.config != null) {
            this.unregisterEventHandlers(this.config.getButtonConfig().getAllEventHandlers());
        }
        this.config = config;
        config.setEventBus(this.eventBus);
        config.getButtonConfig().setEventBus(this.eventBus);
        this.registerEventHandlers(this.config.getButtonConfig().getAllEventHandlers());
        return this;
    }

    public UIConfig getUIConfig() {
        return this.config;
    }

    public DiffMergeViewBuilder setModelSupporter(ModelIdentifier supporter) {
        this.supporter = supporter;
        return this;
    }
}

