/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.buttonadapter;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.ui.config.UIButtonUpdateEvent;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.config.UIConfigUpdateEvent;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelElementSelectedEvent;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.diffmerge2.joint.event.DiffModelChangedEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public abstract class AbstractButtonSelectionAdapter
extends SelectionAdapter
implements EventBusParticipant {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractButtonSelectionAdapter.class.getName());
    private final ModelBusEventBus eventBus;
    private DiffModelElement selection;
    private UIConfig.DiffMergeMode currentMode = UIConfig.DiffMergeMode.SYNCHRONIZE;
    private boolean closeOnCommit;
    private boolean closeOnUpdate;
    private final String uiConfigID;

    abstract void handelSelection(Button var1, DiffModelElement var2);

    AbstractButtonSelectionAdapter(String uiConfigID, ModelBusEventBus eventBus) {
        this.uiConfigID = uiConfigID;
        this.eventBus = eventBus;
    }

    @Handler
    public void diffModelElementSelectedEventHandler(DiffModelElementSelectedEvent event) {
        this.selection = event.getElement();
    }

    @Handler
    public void diffModelChangedEventHandler(DiffModelChangedEvent event) {
        this.selection = null;
    }

    @Handler
    public void UIButtonConfigEventHandler(UIButtonUpdateEvent event) {
        this.closeOnCommit = event.isCloseOnCommit();
        this.closeOnUpdate = event.isCloseOnUpdate();
    }

    protected boolean isCloseOnCommit() {
        return this.closeOnCommit;
    }

    public boolean isCloseOnUpdate() {
        return this.closeOnUpdate;
    }

    @Handler
    public void uiConfigUpdateEventHandler(UIConfigUpdateEvent event) {
        if (event.getConfigID().equals(this.uiConfigID)) {
            this.currentMode = event.getMode();
            this.diffMergeModeChanged(event.getMode());
        }
    }

    protected void diffMergeModeChanged(UIConfig.DiffMergeMode mode) {
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public Collection<Object> getAllEventHandlers() {
        return Lists.newArrayList((Object[])new Object[]{this});
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supported");
    }

    public void widgetSelected(SelectionEvent e) {
        if (((Widget)e.getSource()).isDisposed()) {
            LOG.warn("Button eventhandler is acting for disposed widget!!!!!");
            return;
        }
        if (this.selection != null) {
            this.handelSelection((Button)e.getSource(), this.selection);
        }
    }
}

