/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.util.jdk;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import config.LocationProperty;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.Endpoint;
import org.eclipse.ecf.provider.jaxws.util.EndpointPublisher;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.core.lib.util.LocationsUtilFactory;

public class JdkHttpPublisher
implements EndpointPublisher {
    private static final String SSL_CONTEXT_ALGORITHM_TLS = "TLS";
    private static final String KEY_STORE_TYPE_JKS = "JKS";
    private static final String KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PSWD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final Object HTTPS = "https";

    public void publish(Endpoint endpoint, String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc);
        }
        if (url.getProtocol().equals(HTTPS)) {
            try {
                this.publishSecure(url, endpoint);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ModelBusException exc) {
                throw new RuntimeException(exc);
            }
        } else {
            endpoint.publish(urlStr);
        }
    }

    private void publishSecure(URL url, Endpoint endpoint) throws ModelBusException, IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        String keyStoreFile = null;
        String keyPass = null;
        if (this.isSecureRepository(url)) {
            keyStoreFile = this.getModelBusKeyStoreFile();
            keyPass = this.getModelBusKeyPass();
        } else {
            keyStoreFile = this.getKeystoreFile();
            keyPass = this.getKeyPass();
            if (keyStoreFile != null && keyPass == null) {
                throw new RuntimeException("System Property javax.net.ssl.keyStorePassword must be set");
            }
        }
        KeyManager[] keyManagers = null;
        if (keyStoreFile != null && !keyStoreFile.isEmpty()) {
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            store.load(new FileInputStream(keyStoreFile), keyPass.toCharArray());
            keyFactory.init(store, keyPass.toCharArray());
            keyManagers = keyFactory.getKeyManagers();
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore nullKeyStore = null;
        trustFactory.init(nullKeyStore);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        SSLContext ssl = SSLContext.getInstance(SSL_CONTEXT_ALGORITHM_TLS);
        ssl.init(keyManagers, trustManagers, new SecureRandom());
        HttpsConfigurator configurator = new HttpsConfigurator(ssl);
        InetAddress hostname = InetAddress.getByName(url.getHost());
        int port = url.getPort();
        HttpsServer httpsServer = HttpsServer.create(new InetSocketAddress(hostname, port), port);
        httpsServer.setHttpsConfigurator(configurator);
        String urlPath = url.getPath().toString();
        HttpContext httpContext = httpsServer.createContext(urlPath);
        httpsServer.start();
        endpoint.publish((Object)httpContext);
    }

    private String getModelBusKeyPass() throws ModelBusException {
        LocationProperty prop = ModelBusConfiguration.getLocationProperty((String)"secureRepositoryLocation", (String)"SSLKeyStorePassword");
        if (prop == null) {
            throw new IllegalStateException("Repository property SSLKeyStorePasswordis not configured");
        }
        return prop.getValue();
    }

    private String getModelBusKeyStoreFile() throws ModelBusException {
        LocationProperty prop = ModelBusConfiguration.getLocationProperty((String)"secureRepositoryLocation", (String)"SSLKeyStore");
        if (prop == null) {
            throw new IllegalStateException("Repository property SSLKeyStoreis not configured");
        }
        return ModelBusConfiguration.getAbsoluteConfigFilePath((String)prop.getValue());
    }

    private boolean isSecureRepository(URL url) {
        URL repoUrl;
        AbstractLocationsUtil locationsUtil = LocationsUtilFactory.getInstance().getLocationsUtil();
        String repoLocation = locationsUtil.getSecureRepositoryLocation();
        repoLocation = AbstractLocationsUtil.getExternalLocation((String)repoLocation);
        try {
            repoUrl = new URL(repoLocation);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return url.equals(repoUrl);
    }

    private String getKeyPass() throws ModelBusException {
        return System.getProperty(KEY_STORE_PROPERTY);
    }

    private String getKeystoreFile() {
        return System.getProperty(KEY_STORE_PSWD_PROPERTY);
    }
}

