/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.eclipse.ecf.provider.jaxws.util.Activator;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.provider.jaxws.util.internal.JaxWsConfigUtil;
import org.eclipse.ecf.provider.jaxws.util.internal.MtomUtil;

public class ServerUtil {
    private ServerUtil() {
        throw new IllegalStateException();
    }

    public static Endpoint createEndpoint(Object service, JaxWsParams params, Executor pool) {
        Class<?> serviceClass = service.getClass();
        WebService webService = serviceClass.getAnnotation(WebService.class);
        Class<?> interfaceClass = ServerUtil.findWebServiceInterfaceFromImplementations(serviceClass, webService);
        WebService endpointDef = interfaceClass.getAnnotation(WebService.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        ServerUtil.addServiceName(props, params, webService, endpointDef, interfaceClass);
        ServerUtil.addPortName(props, params, webService, endpointDef, interfaceClass);
        String bindingId = ServerUtil.getBinding(params);
        MTOMFeature mtom = MtomUtil.getMTOMFeature(params);
        Endpoint ep = Endpoint.create((String)bindingId, (Object)service, (WebServiceFeature[])new WebServiceFeature[]{mtom});
        ep.setProperties(props);
        if (pool != null) {
            ep.setExecutor(pool);
        }
        String uri = params.getAddress();
        Activator.getEndpointPublisher().publish(ep, uri);
        return ep;
    }

    private static String getBinding(JaxWsParams params) {
        String result = params.getBindingId();
        if (result == null) {
            result = params.isMtomEnabled() ? "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true" : "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return result;
    }

    private static void addServiceName(Map<String, Object> props, JaxWsParams params, WebService webService, WebService endpointDef, Class<?> interfaceClass) {
        QName serviceName = JaxWsConfigUtil.getServiceName(params, webService, endpointDef, interfaceClass);
        props.put("javax.xml.ws.wsdl.service", serviceName);
    }

    private static void addPortName(Map<String, Object> props, JaxWsParams params, WebService webServiceDef, WebService endpointDef, Class<?> serviceInterface) {
        QName portName = JaxWsConfigUtil.getPortName(params, webServiceDef, endpointDef, serviceInterface);
        props.put("javax.xml.ws.wsdl.port", portName);
    }

    private static Class<?> findWebServiceInterfaceFromImplementations(Class<?> serviceClass, WebService serviceDef) {
        String webServiceInterface;
        String string = webServiceInterface = serviceDef == null ? null : serviceDef.endpointInterface();
        if (webServiceInterface == null || webServiceInterface.isEmpty()) {
            return ServerUtil.findEndpointInterfaceFromInterfaces(serviceClass);
        }
        try {
            Class<?> result = serviceClass.getClassLoader().loadClass(webServiceInterface);
            return result != null ? result : serviceClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return serviceClass;
        }
    }

    private static Class<?> findEndpointInterfaceFromInterfaces(Class<?> serviceClass) {
        Class<?>[] classArray = serviceClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            WebService ser = inter.getAnnotation(WebService.class);
            if (ser != null) {
                return inter;
            }
            ++n2;
        }
        return serviceClass;
    }
}

