/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.diff;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.icon.IconProvider;
import org.modelbus.tools.diffmerge.ui.util.GuiHelperUtil;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class DiffModelLabelProvider
extends LabelProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiffModelLabelProvider.class.getName());
    private final GuiHelperUtil guiUtil;
    private final IconProvider iconProvider;

    DiffModelLabelProvider(GuiHelperUtil guiUtil, IconProvider iconProvider, UIConfig config) {
        this.guiUtil = guiUtil;
        this.iconProvider = iconProvider;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public Image getImage(Object element) {
        Image image;
        if (element instanceof DiffElement) {
            DiffElement diff = (DiffElement)element;
            Object modelElement = diff.getAllDiffElements().size() > 0 ? diff.getAffectedModelElement() : diff.getAffectedFeature();
            if (modelElement == null) {
                return null;
            }
            image = this.iconProvider.getIconForModelElement(modelElement);
            if (image != null) {
                image = this.addOverlayToDiffElement(diff, image);
            }
        } else if (element instanceof DiffModel) {
            image = this.guiUtil.getEcoreImageForEClassName(EPackage.class.getSimpleName());
        } else {
            DiffModelElement modelElement = (DiffModelElement)element;
            if (modelElement == null) {
                return null;
            }
            EObject leftElement = modelElement.getLeftElement();
            if (leftElement == null) {
                return null;
            }
            image = this.iconProvider.getIconForModelElement(leftElement);
        }
        return image;
    }

    private Image addOverlayToDiffElement(DiffElement diff, Image image) {
        Image overlay = null;
        overlay = diff.isConflict() ? this.guiUtil.getConflictOverlay() : this.getCorrectOverlayForSynchronization(diff);
        if (overlay != null) {
            ImageDescriptor overDesc = ImageDescriptor.createFromImage((Image)overlay);
            DecorationOverlayIcon icon = new DecorationOverlayIcon(image, overDesc, 2);
            return icon.createImage();
        }
        return image;
    }

    private Image getCorrectOverlayForSynchronization(DiffElement diff) {
        Image overlay;
        switch (diff.getSource()) {
            case Left: {
                overlay = this.guiUtil.getOutgoingChangeOverlay();
                break;
            }
            default: {
                overlay = this.guiUtil.getIncommingChangeOverlay();
            }
        }
        return overlay;
    }
}

