/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.blackboard.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.engio.mbassy.common.IPredicate;
import net.engio.mbassy.common.ReflectionUtils;
import net.engio.mbassy.subscription.MessageEnvelope;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Enveloped;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Filter;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.IMessageFilter;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Listener;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.MessageHandlerMetadata;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.MessageInterfaceMetadata;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.MessageListenerMetadata;

public class MetadataReader {
    private static final IPredicate<Method> AllMessageHandlers = new IPredicate<Method>(){

        @Override
        public boolean apply(Method target) {
            return target.getAnnotation(Handler.class) != null;
        }
    };
    private static final IPredicate<Class<?>> AllMessagesHandledByInterface = new IPredicate<Class<?>>(){

        @Override
        public boolean apply(Class<?> target) {
            return target.isInterface() && Listener.class.isAssignableFrom(target);
        }
    };
    private final Map<Class<? extends IMessageFilter>, IMessageFilter> filterCache = new HashMap<Class<? extends IMessageFilter>, IMessageFilter>();

    private IMessageFilter[] getFilter(Handler subscription) {
        if (subscription.filters().length == 0) {
            return null;
        }
        IMessageFilter[] filters = new IMessageFilter[subscription.filters().length];
        int i = 0;
        Filter[] filterArray = subscription.filters();
        int n = filterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filterDef = filterArray[n2];
            IMessageFilter filter = this.filterCache.get(filterDef.value());
            if (filter == null) {
                try {
                    filter = filterDef.value().newInstance();
                    this.filterCache.put(filterDef.value(), filter);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            filters[i] = filter;
            ++i;
            ++n2;
        }
        return filters;
    }

    public MessageHandlerMetadata getHandlerMetadata(Method messageHandler) {
        Handler config = messageHandler.getAnnotation(Handler.class);
        return new MessageHandlerMetadata(messageHandler, this.getFilter(config), config);
    }

    public List<MessageHandlerMetadata> getMessageHandlers(Class<?> target) {
        List<Method> allHandlers = ReflectionUtils.getMethods(AllMessageHandlers, target);
        LinkedList<Method> bottomMostHandlers = new LinkedList<Method>();
        for (Method handler : allHandlers) {
            if (ReflectionUtils.containsOverridingMethod(allHandlers, handler)) continue;
            bottomMostHandlers.add(handler);
        }
        LinkedList<MessageHandlerMetadata> filteredHandlers = new LinkedList<MessageHandlerMetadata>();
        for (Method handler : bottomMostHandlers) {
            Handler handle = handler.getAnnotation(Handler.class);
            if (!handle.enabled() || !this.isValidMessageHandler(handler)) continue;
            Method overriddenHandler = ReflectionUtils.getOverridingMethod(handler, target);
            MessageHandlerMetadata handlerMetadata = new MessageHandlerMetadata(overriddenHandler == null ? handler : overriddenHandler, this.getFilter(handle), handle);
            filteredHandlers.add(handlerMetadata);
        }
        return filteredHandlers;
    }

    public <T> MessageListenerMetadata<T> getMessageListener(Class<T> target) {
        List<MessageHandlerMetadata> messageHandlers = this.getMessageHandlers(target);
        MessageListenerMetadata<T> messageListenerMetadata = new MessageListenerMetadata<T>(messageHandlers, target);
        return messageListenerMetadata;
    }

    private boolean isValidMessageHandler(Method handler) {
        if (handler == null || handler.getAnnotation(Handler.class) == null) {
            return false;
        }
        if (handler.getParameterTypes().length != 1) {
            System.out.println("Found no or more than one parameter in messageHandler [" + handler.getName() + "]. A messageHandler must define exactly one parameter");
            return false;
        }
        Enveloped envelope = handler.getAnnotation(Enveloped.class);
        if (envelope != null && !MessageEnvelope.class.isAssignableFrom(handler.getParameterTypes()[0])) {
            System.out.println("Message envelope configured but no subclass of MessageEnvelope found as parameter");
            return false;
        }
        if (envelope != null && envelope.messages().length == 0) {
            System.out.println("Message envelope configured but message types defined for handler");
            return false;
        }
        return true;
    }

    public Collection<MessageHandlerMetadata> getMessagesHandledByInterface(Class<?> listeningClass) {
        HashSet messageHandlers = Sets.newHashSet();
        Set supers = TypeToken.of(listeningClass).getTypes().rawTypes();
        for (Class clazz : supers) {
            if (!AllMessagesHandledByInterface.apply(clazz)) continue;
            for (Method meth : this.getMethodsDefinedInInterface(clazz)) {
                messageHandlers.add(new MessageInterfaceMetadata(meth));
            }
        }
        return messageHandlers;
    }

    protected List<Method> getMethodsDefinedInInterface(Class<?> clazz) {
        Method[] methods;
        LinkedList result = Lists.newLinkedList();
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method meth = methodArray[n2];
            if (meth.getParameterTypes().length == 1) {
                result.add(meth);
            }
            ++n2;
        }
        return result;
    }
}

