/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.tools.diffmerge.DiffMergeListener;
import org.modelbus.tools.diffmerge.IDiffMerge;
import org.modelbus.tools.diffmerge.merge.ElementAlreadyMergedEvent;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge2.joint.event.MergeDiffModelElementEvent;
import org.modelbus.tools.diffmerge2.joint.event.ShutDownEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class DiffMergeEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiffMergeEventHandler.class.getName());
    private final IDiffMerge diffMerge;
    private final Set<DiffMergeListener> listeners = Sets.newHashSet();

    DiffMergeEventHandler(IDiffMerge diffMerge) {
        this.diffMerge = diffMerge;
    }

    @Handler
    public void mergeDiffModelElementEventHandler(MergeDiffModelElementEvent event) {
        DiffModelElement diffElement = event.getElement();
        if (event.isLeftToRight()) {
            LOG.debug(String.format("%s received. Merging from left to right! ", diffElement.getClass().getSimpleName()));
            this.diffMerge.mergeElementToRight(diffElement, event.isIgnoreConflicts());
        } else {
            LOG.debug(String.format("%s received. Merging from right to left! ", diffElement.getClass().getSimpleName()));
            this.diffMerge.mergeElementToLeft(diffElement, event.isIgnoreConflicts());
        }
    }

    @Handler
    public void elementAlreadyMergedEventHandler(ElementAlreadyMergedEvent event) {
        switch (event.getTargetDirection()) {
            case LEFT: {
                this.notifyAllListeners(event.getResources(), false);
                break;
            }
            case RIGHT: {
                this.notifyAllListeners(event.getResources(), true);
            }
        }
    }

    private void notifyAllListeners(Resource[] resources, boolean leftToRight) {
        for (DiffMergeListener listener : this.listeners) {
            if (leftToRight) {
                listener.onMergeFromLeftToRight(this.diffMerge, resources);
                continue;
            }
            listener.onMergeFromRightToLeft(this.diffMerge, resources);
        }
    }

    void addListener(DiffMergeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    void removeListener(DiffMergeListener listener) {
        this.listeners.remove(listener);
    }

    @Handler
    public void shutDownEventHandler(ShutDownEvent event) {
        ModelBusEventBus eventBus = this.diffMerge.getEventBus();
        eventBus.unregister(this.diffMerge.getAllEventHandlers());
    }
}

