/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.controller.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.tools.diffmerge.DiffMergeListener;
import org.modelbus.tools.diffmerge.IDiffMerge;
import org.modelbus.tools.diffmerge.IDiffMergeListener;
import org.modelbus.tools.diffmerge.controller.IDiffMergeController;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.diffmerge.ui.UIListener;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class DiffMergeListenerWrapper
implements UIListener,
DiffMergeListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiffMergeListenerWrapper.class.getName());
    private Set<IDiffMergeListener> listeners = Sets.newHashSet();
    private final IDiffMergeController controller;
    private final IDiffMerge source;

    DiffMergeListenerWrapper(IDiffMergeController controller, IDiffMerge source) {
        this.controller = controller;
        this.source = source;
    }

    void addListener(IDiffMergeListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(IDiffMergeListener listener) {
        this.listeners.remove(listener);
    }

    public void onMergeFromLeftToRight(IDiffMerge source, Resource ... mergedResources) {
        if (!this.source.equals(source)) {
            return;
        }
        LOG.debug("merge from left to right === commit");
        for (IDiffMergeListener listener : this.listeners) {
            listener.onCommit(this.controller, mergedResources);
        }
    }

    public void onMergeFromRightToLeft(IDiffMerge source, Resource ... mergedResources) {
        if (!this.source.equals(source)) {
            return;
        }
        LOG.debug("merge from right to left === update");
        for (IDiffMergeListener listener : this.listeners) {
            listener.onUpdate(this.controller, mergedResources);
        }
    }

    public void onUpdateButtonClicked(DiffMergeView source) {
        LOG.debug("Update button pressed ");
    }

    public void onCommitButtonClicked(DiffMergeView source) {
        LOG.debug("Commit button pressed ");
    }

    public void onViewClosed(DiffMergeView source) {
        LOG.debug("View closed ");
    }

    public void onCancelButtonClicked(DiffMergeView source) {
        LOG.debug("Cancel button clicked");
        for (IDiffMergeListener listener : this.listeners) {
            listener.onClose(this.controller, true);
        }
    }

    public void onOkButtonClicked(DiffMergeView source) {
        LOG.debug("OK button clicked");
        for (IDiffMergeListener listener : this.listeners) {
            listener.onClose(this.controller, false);
        }
    }
}

