/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collections;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiTypeConverter
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry,
ServiceTrackerCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiTypeConverter.class);
    private final BundleContext bundleContext;
    private final Injector injector;
    private final FactoryFinder factoryFinder;
    private final ServiceTracker tracker;
    private volatile DefaultTypeConverter delegate;

    public OsgiTypeConverter(BundleContext bundleContext, Injector injector, FactoryFinder factoryFinder) {
        this.bundleContext = bundleContext;
        this.injector = injector;
        this.factoryFinder = factoryFinder;
        this.tracker = new ServiceTracker(bundleContext, TypeConverterLoader.class.getName(), (ServiceTrackerCustomizer)this);
    }

    public Object addingService(ServiceReference serviceReference) {
        LOG.trace("AddingService: {}", (Object)serviceReference);
        TypeConverterLoader loader = (TypeConverterLoader)this.bundleContext.getService(serviceReference);
        if (loader != null) {
            try {
                loader.load(this.getDelegate());
            }
            catch (Throwable t) {
                throw ObjectHelper.wrapRuntimeCamelException(t);
            }
        }
        return loader;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        LOG.trace("RemovedService: {}", (Object)serviceReference);
        try {
            ServiceHelper.stopService(this.delegate);
        }
        catch (Exception e) {
            LOG.debug("Error stopping service due: " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
        }
        this.delegate = null;
    }

    @Override
    protected void doStart() throws Exception {
        this.tracker.open();
    }

    @Override
    protected void doStop() throws Exception {
        this.tracker.close();
        ServiceHelper.stopService(this.delegate);
        this.delegate = null;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.getDelegate().convertTo(type, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.getDelegate().convertTo(type, exchange, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.getDelegate().mandatoryConvertTo(type, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return this.getDelegate().mandatoryConvertTo(type, exchange, value);
    }

    @Override
    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        this.getDelegate().addTypeConverter(toType, fromType, typeConverter);
    }

    @Override
    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        this.getDelegate().addFallbackTypeConverter(typeConverter, canPromote);
    }

    @Override
    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.getDelegate().lookup(toType, fromType);
    }

    @Override
    public void setInjector(Injector injector) {
        this.getDelegate().setInjector(injector);
    }

    @Override
    public Injector getInjector() {
        return this.getDelegate().getInjector();
    }

    public synchronized DefaultTypeConverter getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createRegistry();
        }
        return this.delegate;
    }

    protected DefaultTypeConverter createRegistry() {
        DefaultTypeConverter answer = new DefaultTypeConverter(new DefaultPackageScanClassResolver(){

            @Override
            public Set<ClassLoader> getClassLoaders() {
                return Collections.emptySet();
            }
        }, this.injector, this.factoryFinder);
        try {
            answer.loadCoreTypeConverters();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error loading CoreTypeConverter due: " + e.getMessage(), e);
        }
        Object[] services = this.tracker.getServices();
        if (services != null) {
            for (Object o : services) {
                try {
                    ((TypeConverterLoader)o).load(answer);
                }
                catch (Throwable t) {
                    throw new RuntimeCamelException("Error loading type converters from service: " + o + " due: " + t.getMessage(), t);
                }
            }
        }
        LOG.trace("Created TypeConverter: {}", (Object)answer);
        return answer;
    }
}

