/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.discovery;

import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.discovery.CompositeNamespace;
import org.eclipse.ecf.provider.discovery.CompositeDiscoveryContainer;
import org.eclipse.ecf.provider.discovery.CompositeDiscoveryContainerInstantiator;
import org.eclipse.ecf.provider.discovery.SingletonDiscoveryContainerInstantiator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.discovery";
    public static final boolean ENABLED;

    static {
        ENABLED = new Boolean(System.getProperty("org.eclipse.ecf.provider.discovery.enable", "false"));
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Activator() {
        plugin = this;
    }

    public void start(final BundleContext context) throws Exception {
        if (ENABLED) {
            context.registerService(Namespace.class, (Object)new CompositeNamespace(), null);
            context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.composite", (IContainerInstantiator)new CompositeDiscoveryContainerInstantiator(), "Composite Discovery Container", true, false), null);
            context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.singleton.discovery", (IContainerInstantiator)new SingletonDiscoveryContainerInstantiator(), "Composite Discovery Container Locator", true, false), null);
            context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.composite.locator", (IContainerInstantiator)new CompositeDiscoveryContainerInstantiator(), "Composite Discovery Container Locator"), null);
            context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.composite.advertiser", (IContainerInstantiator)new CompositeDiscoveryContainerInstantiator(), "Composite Discovery Container Advertiser"), null);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("org.eclipse.ecf.discovery.containerName", "ecf.discovery.composite");
            props.put("service.ranking", new Integer(1000));
            String[] clazzes = new String[]{IDiscoveryService.class.getName(), IDiscoveryLocator.class.getName(), IDiscoveryAdvertiser.class.getName()};
            context.registerService(clazzes, (Object)new ServiceFactory(){

                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    final CompositeDiscoveryContainer cdc = new CompositeDiscoveryContainer(new HashSet());
                    try {
                        cdc.connect(null, null);
                    }
                    catch (ContainerConnectException e) {
                        Trace.catching((String)Activator.PLUGIN_ID, (String)"org.eclipse.ecf.provider.discovery/debug/methods/catching", this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                        return null;
                    }
                    Filter filter = null;
                    try {
                        String filter2 = "(&(objectClass=" + IDiscoveryAdvertiser.class.getName() + ")(!(" + "org.eclipse.ecf.discovery.containerName" + "=" + "ecf.discovery.composite" + ")))";
                        filter = context.createFilter(filter2);
                        context.addServiceListener(new ServiceListener(){

                            public void serviceChanged(ServiceEvent arg0) {
                                Object anIDS = context.getService(arg0.getServiceReference());
                                switch (arg0.getType()) {
                                    case 1: {
                                        cdc.addContainer(anIDS);
                                        break;
                                    }
                                    case 4: {
                                        cdc.removeContainer(anIDS);
                                        break;
                                    }
                                }
                            }
                        }, filter2);
                    }
                    catch (InvalidSyntaxException filter2) {
                        // empty catch block
                    }
                    ServiceTracker tracker = new ServiceTracker(context, filter, null);
                    tracker.open();
                    Object[] services = tracker.getServices();
                    tracker.close();
                    if (services != null) {
                        int i = 0;
                        while (i < services.length) {
                            Object obj = services[i];
                            if (obj != cdc) {
                                cdc.addContainer(obj);
                            }
                            ++i;
                        }
                    }
                    return cdc;
                }

                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                    ((CompositeDiscoveryContainer)((Object)service)).dispose();
                }
            }, props);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
    }
}

