/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.modelbus.desktop.model.RemoteFileDescriptor;

public class RemoteFileEditorInput
implements IEditorInput {
    private static final String FILE_CONTENT_NOT_AVAILABLE = "n/a";
    private RemoteFileDescriptor fileDescriptor;

    public RemoteFileEditorInput(RemoteFileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fileDescriptor.getFileName();
    }

    public URI getURI() {
        return this.fileDescriptor.getURI();
    }

    public String getRevision() {
        return this.fileDescriptor.getRevision();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return String.valueOf(this.fileDescriptor.getURI().toString()) + " [" + this.fileDescriptor.getRevision() + "]";
    }

    public InputStream getInputStream() {
        return this.fileDescriptor.getInputStream();
    }

    public String getFileContent() {
        if (this.fileDescriptor == null) {
            return FILE_CONTENT_NOT_AVAILABLE;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(String.valueOf(line) + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return FILE_CONTENT_NOT_AVAILABLE;
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RemoteFileEditorInput)) {
            return false;
        }
        return this.getURI().toString().equals(((RemoteFileEditorInput)other).getURI().toString());
    }
}

