/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.repository;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogEntry;

public class RevisionTableViewerSorter
extends ViewerSorter {
    private static final int ASCENDING = 0;
    private static final int DESCENDING = 1;
    private int column = 0;
    private int direction = 0;

    public void doSort(int column) {
        if (column == this.column) {
            this.direction = 1 - this.direction;
        } else {
            this.column = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        RepositoryLogEntry p1 = (RepositoryLogEntry)e1;
        RepositoryLogEntry p2 = (RepositoryLogEntry)e2;
        switch (this.column) {
            case 0: {
                rc = Long.valueOf(p1.getRevision()).compareTo(Long.valueOf(p2.getRevision()));
                break;
            }
            case 1: {
                rc = p1.getDate().compare(p2.getDate());
                break;
            }
            case 2: {
                rc = p1.getAuthor().compareTo(p2.getAuthor());
                break;
            }
            case 3: {
                rc = p1.getMessage().compareTo(p2.getMessage());
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        TableViewer tableViewer = (TableViewer)viewer;
        tableViewer.getTable().setSortColumn(tableViewer.getTable().getColumn(this.column));
        if (this.direction == 0) {
            tableViewer.getTable().setSortDirection(1024);
        } else {
            tableViewer.getTable().setSortDirection(128);
        }
        return rc;
    }
}

