/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.filter.impl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilter;
import org.modelbus.tools.diffmerge.filter.IDiffModelFilter;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class DiffModelFilterImpl
implements IDiffModelFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DiffModelFilterImpl.class);
    private boolean filterSingleElement;
    private final Set<String> featureNames = Sets.newHashSet();
    private final DiffMergeFilter filter;
    private boolean ignoreOrder;

    public DiffModelFilterImpl(DiffMergeFilter filter) {
        this.filter = filter;
        this.filter.ignoreOrderingChanges(true);
    }

    @Override
    public void setFilterSingleElement(boolean b) {
        this.filterSingleElement = b;
        this.updateFilter();
    }

    private void updateFilter() {
        this.filter.clear();
        this.filter.ignoreOrderingChanges(true);
        String[] names = this.featureNames.toArray(new String[this.featureNames.size()]);
        if (this.filterSingleElement) {
            this.filter.ignoreAllButNames(names);
        } else {
            this.filter.ignoreAllByName(names);
        }
        this.filter.ignoreOrderingChanges(this.ignoreOrder);
        this.filter.update();
    }

    @Override
    public void addFeatureToFilter(String ... featureNames) {
        this.featureNames.addAll(Arrays.asList(featureNames));
        this.updateFilter();
    }

    @Override
    public void setFilteredByTypes(boolean value) {
        if (value) {
            LOG.debug("Enable Filter-By-Type");
        } else {
            LOG.debug("Disable Filter-By-Type");
        }
    }

    @Override
    public boolean shallElementFilterdFromModel(DiffModelElement element) {
        LOG.debug("filter element not implemented.");
        return false;
    }

    @Override
    public void setFilterProfileApplication(boolean value) {
    }

    @Override
    public void setIgnoreOrderingChanged(boolean value) {
        this.ignoreOrder = value;
        this.updateFilter();
    }
}

