/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.config;

import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.web.config.AbstractConfiguration;

public class SystemPropertiesConfiguration
extends AbstractConfiguration {
    private static final String PROPERTY_JMS_URL = "webconsole.jms.url";
    private static final String PROPERTY_JMS_USER = "webconsole.jms.user";
    private static final String PROPERTY_JMS_PASSWORD = "webconsole.jms.password";
    private static final String PROPERTY_JMX_URL = "webconsole.jmx.url";
    private static final String PROPERTY_JMX_USER = "webconsole.jmx.user";
    private static final String PROPERTY_JMX_PASSWORD = "webconsole.jmx.password";

    @Override
    public ConnectionFactory getConnectionFactory() {
        String jmsUrl = System.getProperty(PROPERTY_JMS_URL);
        if (jmsUrl == null) {
            throw new IllegalArgumentException("A JMS-url must be specified (system property webconsole.jms.url");
        }
        String jmsUser = System.getProperty(PROPERTY_JMS_USER);
        String jmsPassword = System.getProperty(PROPERTY_JMS_PASSWORD);
        return this.makeConnectionFactory(jmsUrl, jmsUser, jmsPassword);
    }

    @Override
    public Collection<JMXServiceURL> getJmxUrls() {
        String jmxUrls = System.getProperty(PROPERTY_JMX_URL);
        return this.makeJmxUrls(jmxUrls);
    }

    @Override
    public String getJmxPassword() {
        return System.getProperty(PROPERTY_JMX_PASSWORD);
    }

    @Override
    public String getJmxUser() {
        return System.getProperty(PROPERTY_JMX_USER);
    }
}

