/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services.api;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.services.AbstractModelBusActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractModelBusServiceActivator
extends AbstractModelBusActivator {
    private static final String DEFAULT_SERVICES_HOST = "0.0.0.0";
    private static final int DEFAULT_SERVICE_PORT = 80;
    private ServiceRegistration<?> registration;
    private Object serviceInstance;
    private static boolean servicesHTTPServiceCreated = false;
    private static boolean modelBusHTTPServiceFound = false;
    private static int serviceHTTPServicePort = 80;

    @Override
    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        this.createModelBusHTTPServiceTracker();
        ModelBusServiceConfiguration config = this.getConfiguration();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.exported.interfaces", "*");
        ((Dictionary)props).put("service.exported.configs", "org.apache.cxf.ws");
        String effectiveServiceAddress = null;
        if (config.isOptionSet("serviceAddress")) {
            String serviceAddress = (String)config.getOption("serviceAddress");
            ((Dictionary)props).put("org.apache.cxf.ws.address", serviceAddress);
            effectiveServiceAddress = serviceAddress;
        } else if (config.isOptionSet("osgiServiceContext")) {
            System.out.println("Publishing via OSGi HTTP Service is currently not supported, using standalone JAX-WS.");
            String serviceContext = (String)config.getOption("osgiServiceContext");
            ((Dictionary)props).put("org.apache.cxf.ws.httpservice.context", serviceContext);
            if (!this.getServiceInterface().getName().equals(RepositoryService.class.getName())) {
                if (!modelBusHTTPServiceFound && !servicesHTTPServiceCreated) {
                    servicesHTTPServiceCreated = true;
                    effectiveServiceAddress = "http://0.0.0.0:" + serviceHTTPServicePort + serviceContext;
                } else {
                    effectiveServiceAddress = "http://0.0.0.0:" + AbstractModelBusServiceActivator.getModelBusRepositoryPort() + serviceContext;
                }
            } else {
                effectiveServiceAddress = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation(true);
            }
        } else {
            throw new ModelBusServiceException("Either ModelBusServiceConfiguration OPTION_SERVICE_ADDRESS or OPTION_OSGI_HTTP_SERVICE_CONTEXT must be set.");
        }
        effectiveServiceAddress = AbstractLocationsUtil.getExternalLocation((String)effectiveServiceAddress);
        config.setOption("effectiveServiceAddress", (Object)effectiveServiceAddress);
        String databinding = (String)config.getOption("databinding");
        ((Dictionary)props).put("org.apache.cxf.ws.databinding", databinding);
        String frontend = (String)config.getOption("frontend");
        ((Dictionary)props).put("org.apache.cxf.ws.frontend", frontend);
        ((Dictionary)props).put("org.apache.cxf.ws.address", effectiveServiceAddress);
        ((Dictionary)props).put("org.apache.cxf.ws.binding", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        Object serviceInstance = this.getServiceInstance();
        String serviceInterfaceName = this.getServiceInterface().getName();
        this.registration = bc.registerService(serviceInterfaceName, serviceInstance, props);
        ModelBusServiceConfiguration.register((ModelBusServiceConfiguration)config);
        System.out.println("Service " + serviceInstance.getClass().getName() + " started at: " + effectiveServiceAddress);
    }

    private void createModelBusHTTPServiceTracker() {
        ServiceTracker st = new ServiceTracker(this.getBundleContext(), HttpService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                if (AbstractModelBusServiceActivator.isModelBusHTTPService(reference)) {
                    modelBusHTTPServiceFound = true;
                }
                return super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                if (AbstractModelBusServiceActivator.isModelBusHTTPService(reference)) {
                    modelBusHTTPServiceFound = false;
                }
                super.removedService(reference, service);
            }
        };
        st.open();
    }

    private static boolean isModelBusHTTPService(ServiceReference<?> reference) {
        Bundle[] bundles = reference.getUsingBundles();
        if (bundles == null) {
            return false;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ("org.modelbus.server.embedded".equals(bundle.getSymbolicName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int getModelBusRepositoryPort() {
        String repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation(true);
        URI repoURI = URI.createURI((String)repoLocation);
        return Integer.valueOf(repoURI.port());
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.registration.unregister();
    }

    private Object getServiceInstance() throws ModelBusServiceException {
        if (this.serviceInstance == null) {
            this.serviceInstance = this.createServiceInstance();
            if (!this.getServiceInterface().isAssignableFrom(this.serviceInstance.getClass())) {
                throw new ModelBusServiceException("Service instance does not implement interface: " + this.getServiceInterface().getName());
            }
        }
        return this.serviceInstance;
    }

    protected abstract Object createServiceInstance();

    static /* synthetic */ boolean access$1() {
        return modelBusHTTPServiceFound;
    }
}

