/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementCollection;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffModelException;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class DiffModelElementImpl
implements DiffModelElement {
    private static final Logger LOG = LoggerFactory.getLogger(DiffModelElementImpl.class);
    private final List<DiffModelElement> nodes = Lists.newLinkedList();
    private DiffModelElement parent;
    private final DiffCollection<DiffElement> diffs = DiffElementCollection.createNewCollection();
    private final Match match;
    private final ModelIdentifier identifier;

    DiffModelElementImpl(Match match, ModelIdentifier identifier) {
        this.match = match;
        this.identifier = identifier;
    }

    public Optional<DiffModelElement> getParentElement() {
        return Optional.fromNullable((Object)this.parent);
    }

    public String toString() {
        int cnt = this.getAllDiffElements().size();
        EObject element = this.getMatchingElement();
        String name = this.identifier.getName(element);
        return String.format("%d difference(s) in %s", cnt, name);
    }

    private EObject getMatchingElement() {
        EObject element = this.match.getLeft();
        if (element == null) {
            element = this.match.getRight();
        }
        if (element == null) {
            throw new DiffModelException("Either left nor right matching element found");
        }
        return element;
    }

    public List<DiffModelElement> getSubElements() {
        LinkedList subs = Lists.newLinkedList();
        subs.addAll(this.getDiffElements().toList());
        subs.addAll(this.nodes);
        return ImmutableList.copyOf((Collection)subs);
    }

    public List<DiffModelElement> getAllSubElements() {
        LinkedList result = Lists.newLinkedList();
        result.addAll(this.nodes);
        for (DiffModelElement node : this.nodes) {
            result.addAll(node.getAllSubElements());
        }
        return ImmutableList.copyOf((Collection)result);
    }

    public DiffCollection<DiffElement> getAllDiffElements() {
        LinkedList result = Lists.newLinkedList(this.diffs);
        for (DiffModelElement sub : this.nodes) {
            result.addAll(sub.getAllDiffElements().toList());
        }
        return DiffElementCollection.createNewCollection(result);
    }

    public DiffCollection<DiffElement> getDiffElements() {
        return DiffElementCollection.createNewCollection(this.diffs.toList());
    }

    void setParent(DiffModelElement parent) {
        if (this.parent != null) {
            throw new DiffModelException("Parent is allready set");
        }
        this.parent = parent;
    }

    boolean addNode(DiffModelElement node) {
        if (!this.nodes.contains(node)) {
            return this.nodes.add(node);
        }
        return false;
    }

    boolean addDiff(DiffElement diff) {
        return this.diffs.add((Object[])new DiffElement[]{diff});
    }

    Match getMatch() {
        return this.match;
    }

    public EObject getLeftElement() {
        return this.match.getLeft();
    }

    public EObject getRightElement() {
        return this.match.getRight();
    }

    public Optional<EObject> getOriginElement() {
        return Optional.fromNullable((Object)this.match.getOrigin());
    }

    public void removeSubElement(DiffModelElement element) {
        if (!element.getConflictingElements().isEmpty()) {
            LOG.error(String.format("DiffModelElement '%s' has conflicts. Element does not get removed", element.toString()));
            return;
        }
        this.removeElement(element, false);
    }

    private void removeElement(DiffModelElement element, boolean ignoreConflict) {
        if (element instanceof DiffElement) {
            this.removeDiffElement((DiffElement)element, ignoreConflict);
        } else {
            this.removeModelElement(element);
        }
    }

    public void removeConflictingSubElement(DiffModelElement conflictingElement) {
        if (conflictingElement.getConflictingElements().isEmpty()) {
            LOG.error(String.format("DiffModelElement '%s' has no conflicts. Element does not get removed", conflictingElement.toString()));
            return;
        }
        this.removeElement(conflictingElement, true);
    }

    private void removeModelElement(DiffModelElement element) {
        this.nodes.remove(element);
    }

    private void removeDiffElement(DiffElement element, boolean ignoreConflict) {
        if (!element.isConflict() || ignoreConflict) {
            this.diffs.remove((Object)element);
        }
    }

    public DiffCollection<DiffElement> getConflictingElements() {
        DiffCollection<DiffElement> conflicts = DiffElementCollection.createNewCollection();
        for (DiffElement element : this.getAllDiffElements()) {
            if (!element.isConflict()) continue;
            conflicts.add((Object[])new DiffElement[]{element});
        }
        return conflicts;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.diffs, this.match, this.nodes});
    }
}

