/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.auth;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.desktop.auth.LoginDialog;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.util.ModelBusDesktopUtil;

public class LoginWindowActionDelegate
implements IWorkbenchWindowActionDelegate {
    private Shell shell;

    public void run(IAction action) {
        if (UserSessionHelper.getInstance().getSession() != null) {
            UserSessionHelper.getInstance().destroySession();
            action.setText("Login");
            action.setToolTipText("ModelBus Manager Login");
            return;
        }
        LoginDialog loginDialog = new LoginDialog(this.shell);
        int loginStatus = loginDialog.open();
        if (loginStatus == 0) {
            String username = loginDialog.getUsername();
            String password = loginDialog.getPassword();
            String sessionID = null;
            try {
                sessionID = ModelBusCoreLib.getRepositoryHelper().authenticate(username, password);
                if (sessionID != null) {
                    UserSessionHelper.getInstance().setUsername(username);
                    UserSessionHelper.getInstance().setPassword(password);
                    Status status = ModelBusCoreLib.getServicesHelper().getStatus(UserSessionHelper.getInstance().getSession(), true);
                    ModelBusDesktopUtil.getInstance().getStatus().setStatus(status);
                    action.setText("Logout");
                    action.setToolTipText("Close current session (User: " + UserSessionHelper.getInstance().getUsername() + ")");
                } else {
                    MessageDialog.openInformation((Shell)this.shell, (String)"Login", (String)"Login failed");
                }
            }
            catch (Exception e1) {
                MessageDialog.openInformation((Shell)this.shell, (String)"Login", (String)e1.getMessage());
                e1.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.shell = window.getShell();
    }
}

