/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.jms.JMSException;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.ModelBusTopicListener;
import org.modelbus.core.lib.notification.NotificationLocationStatus;

public class NotificationListenerManager
implements Observer {
    private static NotificationListenerManager notificationListenerManager = null;
    private static NotificationLocationStatus notificationLocationStatus;
    HashSet<INotificationListener> notificationListeners = new HashSet();

    private NotificationListenerManager() {
    }

    public static synchronized NotificationListenerManager getNotificationListenerManager() {
        if (notificationListenerManager == null) {
            notificationListenerManager = new NotificationListenerManager();
            notificationLocationStatus = new NotificationLocationStatus();
            notificationLocationStatus.addObserver(notificationListenerManager);
            ModelBusTopicListener.getTopicListener().startModelbusTopicListener();
        }
        return notificationListenerManager;
    }

    public void addNotificationListener(INotificationListener notificationListener) {
        this.notificationListeners.add(notificationListener);
    }

    public void removeNotificationListener(INotificationListener notificationListener) {
        this.notificationListeners.remove(notificationListener);
    }

    public void notify(String url, String mode, String username, String sessionID) {
        ArrayList<INotificationListener> listeners = new ArrayList<INotificationListener>(this.notificationListeners);
        for (INotificationListener notificationListener : listeners) {
            notificationListener.notification(url, mode, username, sessionID);
        }
    }

    public void notifyChangeModelNotificationListener(String modelUri, String messageID, String changeModelContent) {
        ArrayList<INotificationListener> listeners = new ArrayList<INotificationListener>(this.notificationListeners);
        for (INotificationListener notificationListener : listeners) {
            notificationListener.commitChangeModelNotification(modelUri, messageID, changeModelContent);
        }
    }

    public synchronized boolean startModelBusTopicListener() {
        ModelBusTopicListener modelBusTopicListener = ModelBusTopicListener.getTopicListener();
        modelBusTopicListener.startModelbusTopicListener();
        return modelBusTopicListener.isModelbusTopicListenerThreadRunning();
    }

    public synchronized boolean stopModelBusTopicListener() throws ModelBusException {
        try {
            ModelBusTopicListener modelBusTopicListener = ModelBusTopicListener.getTopicListener();
            modelBusTopicListener.stopModelbusTopicListener();
            return modelBusTopicListener.isModelbusTopicListenerThreadRunning();
        }
        catch (JMSException jmsException) {
            throw new ModelBusException(jmsException);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof NotificationLocationStatus && ((NotificationLocationStatus)o).isAvailable()) {
            ModelBusTopicListener.getTopicListener().startModelbusTopicListener();
        }
    }

    public synchronized NotificationLocationStatus getNotificationLocationStatus() {
        return notificationLocationStatus;
    }
}

