/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.changemodelnotification.provider.cxf.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.modelbus.repositorychangemodelnotification.RepositoryChangeModelNotification;

public class SimpleRepositoryChangeModelNotification
implements RepositoryChangeModelNotification {
    private static final String TOPIC_NAME = "RepositoryChangeModelNotification";
    private static final String PROPERTY_IS_FAULT = "SOAPJMS_isFault";
    private static final String PROPERTY_BINDING_VERSION = "SOAPJMS_bindingVersion";
    private static final String PROPERTY_CONTENT_TYPE = "SOAPJMS_contentType";
    private static final String PROPERTY_REQUESTED_URI = "SOAPJMS_requestURI";
    private static final String PROPERTY_SOAP_ACTION = "SOAPJMS_soapAction";
    private final Connection connection;
    private final Session session;
    private final Topic notificationTopic;
    private static final String MSG_TEMPLATE = "\n--uuid:{0}\nContent-Type: application/xop+xml; charset=UTF-8; type=\"text/xml\"\nContent-Transfer-Encoding: binary\nContent-ID: <root.message@cxf.apache.org>\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:commitChangeModel xmlns:ns2=\"http://www.modelbus.org/RepositoryChangeModelNotification/\"><messageID>{2}</messageID><modelLocation>{3}</modelLocation><changeModelContent><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:{1}@cxf.apache.org\"/></changeModelContent></ns2:commitChangeModel></soap:Body></soap:Envelope>\n--uuid:{0}\nContent-Type: application/octet-stream\nContent-Transfer-Encoding: binary\nContent-ID: <{1}@cxf.apache.org>\n\n";
    private static final MessageFormat MSG_FORMAT = new MessageFormat("\n--uuid:{0}\nContent-Type: application/xop+xml; charset=UTF-8; type=\"text/xml\"\nContent-Transfer-Encoding: binary\nContent-ID: <root.message@cxf.apache.org>\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:commitChangeModel xmlns:ns2=\"http://www.modelbus.org/RepositoryChangeModelNotification/\"><messageID>{2}</messageID><modelLocation>{3}</modelLocation><changeModelContent><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:{1}@cxf.apache.org\"/></changeModelContent></ns2:commitChangeModel></soap:Body></soap:Envelope>\n--uuid:{0}\nContent-Type: application/octet-stream\nContent-Transfer-Encoding: binary\nContent-ID: <{1}@cxf.apache.org>\n\n");
    private static final String MIME_END_IDENTIFIER_TEMPLATE = "\n\n--uuid:{0}--";
    private static final MessageFormat MIME_END_IDENTIFIER_FORMAT = new MessageFormat("\n\n--uuid:{0}--");
    private static final String CONTENT_TYPE_TEMPLATE = "multipart/related; type=\"application/xop+xml\"; boundary=\"uuid:{0}\"; start=\"<root.message@cxf.apache.org>\"; start-info=\"text/xml\"; charset=UTF-8";
    private static final MessageFormat CONTENT_TYPE_FORMAT = new MessageFormat("multipart/related; type=\"application/xop+xml\"; boundary=\"uuid:{0}\"; start=\"<root.message@cxf.apache.org>\"; start-info=\"text/xml\"; charset=UTF-8");
    private static final int BUFFER_SIZE = 16384;

    public SimpleRepositoryChangeModelNotification(String notificationLocation) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(notificationLocation);
        this.connection = factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.notificationTopic = this.session.createTopic(TOPIC_NAME);
    }

    public void commitChangeModel(String messageID, String modelLocation, DataHandler changeModelContent) {
        String msgUUID = UUID.randomUUID().toString();
        String attachmentUUID = UUID.randomUUID().toString();
        String msg = MSG_FORMAT.format(new Object[]{msgUUID, attachmentUUID, messageID, modelLocation});
        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
        String mimeEnd = MIME_END_IDENTIFIER_FORMAT.format(new Object[]{msgUUID});
        byte[] mimeEndBytes = mimeEnd.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] attachmentBytes = this.readBytes(changeModelContent);
            MessageProducer producer = this.session.createProducer((Destination)this.notificationTopic);
            BytesMessage jmsMessage = this.createMessage(msgUUID);
            jmsMessage.clearBody();
            jmsMessage.writeBytes(msgBytes);
            jmsMessage.writeBytes(attachmentBytes);
            jmsMessage.writeBytes(mimeEndBytes);
            producer.send((Message)jmsMessage);
            producer.close();
        }
        catch (JMSException exc) {
            throw new RuntimeException(exc);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private BytesMessage createMessage(String messageUUID) throws JMSException {
        BytesMessage jmsMessage = this.session.createBytesMessage();
        String contentType = CONTENT_TYPE_FORMAT.format(new Object[]{messageUUID});
        jmsMessage.setBooleanProperty(PROPERTY_IS_FAULT, false);
        jmsMessage.setStringProperty(PROPERTY_BINDING_VERSION, "1.0");
        jmsMessage.setStringProperty(PROPERTY_REQUESTED_URI, "jms:topic:RepositoryChangeModelNotification");
        jmsMessage.setStringProperty(PROPERTY_CONTENT_TYPE, contentType);
        jmsMessage.setStringProperty(PROPERTY_SOAP_ACTION, "\"http://www.modelbus.org/RepositoryChangeModelNotification/commitChangeModel\"");
        return jmsMessage;
    }

    private byte[] readBytes(DataHandler changeModelContent) throws IOException {
        int readBytes;
        InputStream is = changeModelContent.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(is.available());
        byte[] data = new byte[16384];
        while ((readBytes = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, readBytes);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public void close() throws JMSException {
        this.session.close();
        this.connection.close();
    }
}

