/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.IServicesHelper;

public class ModelBusCoreLib {
    private static IRepositoryHelper repositoryHelper = null;
    private static IServicesHelper servicesHelper = null;
    private static final String extensionPointID = "org.modelbus.core.lib";
    private static IExtension[] extensions;

    public static IRepositoryHelper getRepositoryHelper() {
        if (repositoryHelper == null) {
            repositoryHelper = ModelBusCoreLib._createRepositoryHelper();
        }
        return repositoryHelper;
    }

    public static IServicesHelper getServicesHelper() {
        if (servicesHelper == null) {
            servicesHelper = ModelBusCoreLib._createServicesHelper();
        }
        return servicesHelper;
    }

    private static IExtension[] getExtensions() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        extensions = extensionPoint.getExtensions();
        return extensions;
    }

    private static IRepositoryHelper _createRepositoryHelper() {
        IRepositoryHelper helper = null;
        try {
            Class.forName("org.eclipse.core.runtime.RegistryFactory");
            IExtension[] iExtensionArray = ModelBusCoreLib.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension element = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement c = iConfigurationElementArray[n4];
                    try {
                        Object exec = c.createExecutableExtension("class");
                        if (exec instanceof IRepositoryHelper) {
                            if (helper == null) {
                                helper = (IRepositoryHelper)c.createExecutableExtension("class");
                            } else {
                                System.out.println("Warning: Multiple ModelBus RepositoryHelper registered. Using: " + helper.getClass().getName());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            try {
                Class<?> repoHelperClass = Class.forName("org.modelbus.core.lib.dosgi.RepositoryHelper");
                return (IRepositoryHelper)repoHelperClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (helper == null) {
            throw new RuntimeException("No ModelBus RepositoryHelper registered.");
        }
        return helper;
    }

    private static IServicesHelper _createServicesHelper() {
        IServicesHelper helper = null;
        try {
            IExtension[] iExtensionArray = ModelBusCoreLib.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension element = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement c = iConfigurationElementArray[n4];
                    try {
                        Object exec = c.createExecutableExtension("class");
                        if (exec instanceof IServicesHelper) {
                            if (helper == null) {
                                helper = (IServicesHelper)c.createExecutableExtension("class");
                            } else {
                                System.out.println("Warning: Multiple ModelBus Services helper registered. Using: " + helper.getClass().getName());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            try {
                Class<?> servicesHelperClass = Class.forName("org.modelbus.core.lib.dosgi.ServicesHelper");
                return (IServicesHelper)servicesHelperClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (helper == null) {
            throw new RuntimeException("No ModelBus Services helper registered.");
        }
        return helper;
    }
}

