/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.core.lib.util.AbstractModelBusEPackageRegistry;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.AccessManager;

public class ModelBusPackageRegistryImpl
extends AbstractModelBusEPackageRegistry {
    private static final long serialVersionUID = 250501014883935077L;
    protected AbstractModelBusRepository modelBusRepository;

    public ModelBusPackageRegistryImpl(AbstractModelBusRepository modelBusRepository) {
        this.modelBusRepository = modelBusRepository;
    }

    protected boolean existsInRepository(URI uri) {
        try {
            return this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isFileInRepository(URI uri) {
        List<IModelBusDirEntry> entries;
        try {
            entries = this.modelBusRepository.info(AccessManager.INTERNAL_MODEL_BUS_SESSION, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (entries == null) {
            return false;
        }
        for (IModelBusDirEntry entry : entries) {
            if (!ModelBusNodeKind.FILE.equals((Object)entry.getKind())) continue;
            return true;
        }
        return false;
    }

    protected Resource checkOutModel(URI uri) {
        try {
            return this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, uri, "-1", new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> getDirEntryNames(URI dirURI) {
        ArrayList<IModelBusDirEntry> entries = new ArrayList<IModelBusDirEntry>();
        ArrayList<String> entryNames = new ArrayList<String>();
        try {
            this.modelBusRepository.getDir(AccessManager.INTERNAL_MODEL_BUS_SESSION, dirURI, "-1", false, entries);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            IModelBusDirEntry iModelBusDirEntry;
            IModelBusDirEntry modelBusDirEntry = iModelBusDirEntry = (IModelBusDirEntry)iterator.next();
            entryNames.add(modelBusDirEntry.getName());
        }
        return entryNames;
    }
}

