/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.URIField;
import org.apache.camel.impl.DefaultEndpointConfiguration;
import org.apache.camel.impl.converter.PropertyEditorTypeConverter;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHelper.class);
    private static final TypeConverter TC = new PropertyEditorTypeConverter();

    private ConfigurationHelper() {
    }

    public static EndpointConfiguration createConfiguration(String uri, CamelContext context) throws Exception {
        String scheme;
        int schemeSeparator = uri.indexOf(58);
        if (schemeSeparator == -1) {
            return null;
        }
        Component component = context.getComponent(scheme = uri.substring(0, schemeSeparator));
        LOG.trace("Lookup for Component handling \"{}:\" configuration returned {}", (Object)scheme, (Object)(component != null ? component.getClass().getName() : "<null>"));
        DefaultEndpointConfiguration cfg = (DefaultEndpointConfiguration)component.createConfiguration(scheme);
        cfg.setURI(new URI(UnsafeUriCharactersEncoder.encode(uri)));
        return cfg;
    }

    public static String formatConfigurationUri(EndpointConfiguration config, EndpointConfiguration.UriFormat format) {
        return "TBD";
    }

    public static void populateFromURI(EndpointConfiguration config, ParameterSetter setter) {
        URI uri = config.getURI();
        setter.set(config, "scheme", uri.getScheme());
        setter.set(config, "schemeSpecificPart", uri.getSchemeSpecificPart());
        setter.set(config, "authority", uri.getAuthority());
        setter.set(config, "userInfo", uri.getUserInfo());
        setter.set(config, "host", uri.getHost());
        setter.set(config, "port", Integer.toString(uri.getPort()));
        setter.set(config, "path", uri.getPath());
        setter.set(config, "query", uri.getQuery());
        setter.set(config, "fragment", uri.getFragment());
        try {
            Map<String, Object> parameters = URISupport.parseParameters(uri);
            for (Map.Entry<String, Object> pair : parameters.entrySet()) {
                setter.set(config, pair.getKey(), pair.getValue());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static Field findConfigurationField(EndpointConfiguration config, String name) {
        if (config != null && name != null) {
            Class<?> clazz = config.getClass();
            Field[] fields = clazz.getDeclaredFields();
            Field found = null;
            URIField anno = null;
            for (Field field : fields) {
                anno = field.getAnnotation(URIField.class);
                if (!(anno == null ? field.getName().equals(name) : anno.component().equals(name) || anno.component().equals("query") && anno.parameter().equals(name))) continue;
                found = field;
                LOG.trace("Found field {}.{} as candidate for parameter {}", new Object[]{clazz.getName(), found != null ? found.getName() : "<null>", name});
                return found;
            }
        }
        return null;
    }

    public static Object getConfigurationParameter(EndpointConfiguration config, String name) {
        Field field = ConfigurationHelper.findConfigurationField(config, name);
        return ConfigurationHelper.getConfigurationParameter(config, field);
    }

    public static Object getConfigurationParameter(EndpointConfiguration config, Field field) {
        if (field != null) {
            try {
                return IntrospectionSupport.getProperty(config, field.getName());
            }
            catch (Exception e) {
                LOG.trace("Filed to invokd setter for field '{}'. Reason: {}", (Object)field.getName(), (Object)e);
            }
        }
        return null;
    }

    public static <T> void setConfigurationField(EndpointConfiguration config, String name, T value) {
        Field field = ConfigurationHelper.findConfigurationField(config, name);
        if (field == null) {
            return;
        }
        try {
            String setterName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Method setter = config.getClass().getMethod(setterName, field.getType());
            setter.invoke((Object)config, TC.convertTo(field.getType(), value));
        }
        catch (Exception e) {
            LOG.trace("Filed to invokd setter for field '{}'. Reason: {}", (Object)name, (Object)e);
            return;
        }
    }

    public static class FieldParameterSetter
    implements ParameterSetter {
        @Override
        public <T> void set(EndpointConfiguration config, String name, T value) {
            ConfigurationHelper.setConfigurationField(config, name, value);
        }
    }

    public static interface ParameterSetter {
        public <T> void set(EndpointConfiguration var1, String var2, T var3);
    }
}

