/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.adapter.BlobJDBCAdapter;

public class OracleBlobJDBCAdapter
extends BlobJDBCAdapter {
    @Override
    public void setStatements(Statements statements) {
        statements.setLongDataType("NUMBER");
        statements.setSequenceDataType("NUMBER");
        String addMessageStatement = "INSERT INTO " + statements.getFullMessageTableName() + "(ID, MSGID_PROD, MSGID_SEQ, CONTAINER, EXPIRATION, PRIORITY, MSG) VALUES (?, ?, ?, ?, ?, ?, empty_blob())";
        statements.setAddMessageStatement(addMessageStatement);
        String findMessageByIdStatement = "SELECT MSG FROM " + statements.getFullMessageTableName() + " WHERE ID=? FOR UPDATE";
        statements.setFindMessageByIdStatement(findMessageByIdStatement);
        super.setStatements(statements);
    }

    @Override
    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        Blob aBlob = rs.getBlob(index);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBytes(1L, (int)aBlob.length());
    }
}

