/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToMockEndpointStrategy
implements EndpointStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToMockEndpointStrategy.class);
    private final String pattern;

    public InterceptSendToMockEndpointStrategy() {
        this(null);
    }

    public InterceptSendToMockEndpointStrategy(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (endpoint instanceof MockEndpoint) {
            return endpoint;
        }
        if (uri == null || this.pattern == null || EndpointHelper.matchEndpoint(endpoint.getCamelContext(), uri, this.pattern)) {
            Producer producer;
            InterceptSendToEndpoint proxy = new InterceptSendToEndpoint(endpoint, false);
            String key = "mock:" + endpoint.getEndpointKey().replaceFirst("://", ":");
            if (key.contains("?")) {
                key = ObjectHelper.before(key, "?");
            }
            LOG.info("Adviced endpoint [" + uri + "] with mock endpoint [" + key + "]");
            MockEndpoint mock = endpoint.getCamelContext().getEndpoint(key, MockEndpoint.class);
            try {
                producer = mock.createProducer();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            proxy.setDetour(producer);
            return proxy;
        }
        return endpoint;
    }

    public String toString() {
        return "InterceptSendToMockEndpointStrategy";
    }
}

