/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Component;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.ConfigurationHelper;
import org.apache.camel.impl.DefaultEndpointConfiguration;
import org.apache.camel.impl.converter.PropertyEditorTypeConverter;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class MappedEndpointConfiguration
extends DefaultEndpointConfiguration {
    private static final TypeConverter CONVERTER = new PropertyEditorTypeConverter();
    private Map<String, Object> params = new ConcurrentHashMap<String, Object>();

    MappedEndpointConfiguration(Component component) {
        super(component);
    }

    @Override
    public <T> T getParameter(String name) {
        return (T)this.params.get(name);
    }

    @Override
    public <T> void setParameter(String name, T value) {
        this.params.put(name, value);
    }

    public boolean equals(Object other) {
        boolean eq = ((Object)this.params).equals(((MappedEndpointConfiguration)other).params);
        return this == other || other != null && this.getClass() == other.getClass() && eq;
    }

    public int hashCode() {
        return ((Object)this.params).hashCode();
    }

    @Override
    protected void parseURI() {
        ConfigurationHelper.populateFromURI(this, new ConfigurationHelper.ParameterSetter(){

            @Override
            public <T> void set(EndpointConfiguration config, String name, T value) {
                if (name != null && value != null) {
                    MappedEndpointConfiguration.this.params.put(name, value);
                }
            }
        });
    }

    @Override
    public String toUriString(EndpointConfiguration.UriFormat format) {
        Set<Map.Entry<String, Object>> entries = this.params.entrySet();
        ArrayList<String> queryParams = new ArrayList<String>();
        String scheme = null;
        String schemeSpecificPart = null;
        String authority = null;
        String path = null;
        String fragment = null;
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("scheme")) {
                scheme = CONVERTER.convertTo(String.class, value);
                continue;
            }
            if (key.equals("schemeSpecificPart")) {
                schemeSpecificPart = CONVERTER.convertTo(String.class, value);
                continue;
            }
            if (key.equals("authority")) {
                authority = CONVERTER.convertTo(String.class, value);
                continue;
            }
            if (key.equals("userInfo") || key.equals("host") || key.equals("port")) continue;
            if (key.equals("path")) {
                path = CONVERTER.convertTo(String.class, value);
                continue;
            }
            if (key.equals("query")) continue;
            if (key.equals("fragment")) {
                fragment = CONVERTER.convertTo(String.class, value);
                continue;
            }
            if (value instanceof List) {
                for (Object item : (List)value) {
                    queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(item.toString()));
                }
                continue;
            }
            queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(value.toString()));
        }
        Collections.sort(queryParams);
        String q = "";
        for (String entry : queryParams) {
            q = q + (q.length() == 0 ? "" : "&");
            q = q + entry;
        }
        StringBuffer u = new StringBuffer(1024);
        if (scheme != null) {
            u.append(scheme);
            u.append(":");
        }
        if (authority != null) {
            u.append("//");
            u.append(authority);
            u.append(path);
            if (q.length() > 0) {
                u.append("?");
                u.append(q);
            }
            if (fragment != null) {
                u.append("#");
                u.append(fragment);
            }
        } else {
            u.append(schemeSpecificPart);
        }
        return u.toString();
    }
}

