/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="idempotentConsumer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdempotentConsumerDefinition
extends ExpressionNode {
    @XmlAttribute
    private String messageIdRepositoryRef;
    @XmlAttribute
    private Boolean eager;
    @XmlAttribute
    private Boolean skipDuplicate;
    @XmlAttribute
    private Boolean removeOnFailure;
    @XmlTransient
    private IdempotentRepository<?> idempotentRepository;

    public IdempotentConsumerDefinition() {
    }

    public IdempotentConsumerDefinition(Expression messageIdExpression, IdempotentRepository<?> idempotentRepository) {
        super(messageIdExpression);
        this.idempotentRepository = idempotentRepository;
    }

    public String toString() {
        return "IdempotentConsumer[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "idempotentConsumer[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "idempotentConsumer";
    }

    public IdempotentConsumerDefinition messageIdRepositoryRef(String messageIdRepositoryRef) {
        this.setMessageIdRepositoryRef(messageIdRepositoryRef);
        return this;
    }

    public IdempotentConsumerDefinition messageIdRepository(IdempotentRepository<?> idempotentRepository) {
        this.setMessageIdRepository(idempotentRepository);
        return this;
    }

    public IdempotentConsumerDefinition eager(boolean eager) {
        this.setEager(eager);
        return this;
    }

    public IdempotentConsumerDefinition removeOnFailure(boolean removeOnFailure) {
        this.setRemoveOnFailure(removeOnFailure);
        return this;
    }

    public IdempotentConsumerDefinition skipDuplicate(boolean skipDuplicate) {
        this.setSkipDuplicate(skipDuplicate);
        return this;
    }

    public String getMessageIdRepositoryRef() {
        return this.messageIdRepositoryRef;
    }

    public void setMessageIdRepositoryRef(String messageIdRepositoryRef) {
        this.messageIdRepositoryRef = messageIdRepositoryRef;
    }

    public IdempotentRepository<?> getMessageIdRepository() {
        return this.idempotentRepository;
    }

    public void setMessageIdRepository(IdempotentRepository<?> idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public Boolean getEager() {
        return this.eager;
    }

    public void setEager(Boolean eager) {
        this.eager = eager;
    }

    public boolean isEager() {
        return this.eager != null ? this.eager : true;
    }

    public Boolean getSkipDuplicate() {
        return this.skipDuplicate;
    }

    public void setSkipDuplicate(Boolean skipDuplicate) {
        this.skipDuplicate = skipDuplicate;
    }

    public boolean isSkipDuplicate() {
        return this.skipDuplicate != null ? this.skipDuplicate : true;
    }

    public Boolean getRemoveOnFailure() {
        return this.removeOnFailure;
    }

    public void setRemoveOnFailure(Boolean removeOnFailure) {
        this.removeOnFailure = removeOnFailure;
    }

    public boolean isRemoveOnFailure() {
        return this.removeOnFailure != null ? this.removeOnFailure : true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        IdempotentRepository<String> idempotentRepository = this.resolveMessageIdRepository(routeContext);
        ObjectHelper.notNull(idempotentRepository, "idempotentRepository", this);
        routeContext.getCamelContext().addService(idempotentRepository);
        Expression expression = this.getExpression().createExpression(routeContext);
        return new IdempotentConsumer(expression, idempotentRepository, this.isEager(), this.isSkipDuplicate(), this.isRemoveOnFailure(), childProcessor);
    }

    protected IdempotentRepository<?> resolveMessageIdRepository(RouteContext routeContext) {
        if (this.messageIdRepositoryRef != null) {
            this.idempotentRepository = routeContext.lookup(this.messageIdRepositoryRef, IdempotentRepository.class);
        }
        return this.idempotentRepository;
    }
}

