/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.compare;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.modelbus.tools.diffmerge.compare.ComparatorBuilder;
import org.modelbus.tools.diffmerge.match.MatchInspector;
import org.modelbus.tools.diffmerge.match.Matcher;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelBuilder;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class Comparer
implements EventBusParticipant {
    private static final Logger LOG = LoggerFactory.getLogger((String)Comparer.class.getName());
    private final ComparatorBuilder comparatorBuilder;
    private final ModelIdentifier identifier;

    public Comparer(Matcher matcher, ModelIdentifier identifier, Collection<MatchInspector> inspectors) {
        this.identifier = identifier;
        this.comparatorBuilder = new ComparatorBuilder(matcher, inspectors);
    }

    public DiffModel comparerThreeWay(Notifier left, Notifier origin, Notifier right) {
        IComparisonScope scope = EMFCompare.createDefaultScope((Notifier)left, (Notifier)right, (Notifier)origin);
        DiffModel model = this.createDiffModelForScope(scope);
        return model;
    }

    private DiffModel createDiffModelForScope(IComparisonScope scope) {
        EMFCompare comparator = this.comparatorBuilder.getComparator();
        Comparison comparison = comparator.compare(scope);
        this.debug(comparison);
        DiffModel model = DiffModelBuilder.createNewBuilder().setModelIdentifier(this.identifier).createNewDiffModel(comparison, scope.getLeft(), scope.getRight());
        return model;
    }

    private void debug(Comparison comparison) {
        EList differences = comparison.getDifferences();
        LOG.debug(String.format("found %d differences", differences.size()));
    }

    public DiffModel compareTwoWay(Notifier left, Notifier right) {
        IComparisonScope scope = EMFCompare.createDefaultScope((Notifier)left, (Notifier)right);
        DiffModel diffModel = this.createDiffModelForScope(scope);
        return diffModel;
    }

    public Collection<Object> getAllEventHandlers() {
        return this.comparatorBuilder.getAllEventHandlers();
    }

    public ModelBusEventBus getEventBus() {
        throw new RuntimeException("Not supported");
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supported");
    }
}

