/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.merge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.tools.diffmerge.merge.ChangesTracker;
import org.modelbus.tools.diffmerge.merge.MergeException;

class ResourceChangesTracker
implements ChangesTracker {
    private final Map<Resource, Boolean> trackedResources = Maps.newHashMap();

    ResourceChangesTracker(Resource ... resources) {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            this.trackedResources.put(res, res.isTrackingModification());
            if (res.isModified()) {
                throw new MergeException(String.format("This resource %s is modified. Please use unmodified resources only", res.getURI().toString()));
            }
            ++n2;
        }
    }

    @Override
    public void startTracking() {
        for (Resource res : this.trackedResources.keySet()) {
            if (this.trackedResources.get(res).booleanValue()) continue;
            res.setTrackingModification(true);
        }
    }

    @Override
    public Resource[] getChangedResources() {
        ArrayList result = Lists.newArrayList();
        for (Resource res : this.trackedResources.keySet()) {
            if (!res.isModified()) continue;
            result.add(res);
        }
        return result.toArray(new Resource[result.size()]);
    }

    @Override
    public void stopTracking() {
        for (Resource res : this.trackedResources.keySet()) {
            if (this.trackedResources.get(res).booleanValue()) continue;
            res.setTrackingModification(false);
        }
    }
}

