/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.client;

import javax.jws.WebService;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.jaxws.util.ClientUtil;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.provider.jaxws.util.UriUtil;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;

public class JaxWsClientService
extends AbstractClientService {
    private final JaxWsParams params;

    public JaxWsClientService(AbstractClientContainer container, RemoteServiceClientRegistration registration, JaxWsParams params) {
        super(container, registration);
        this.params = params.clone();
        String urlStr = UriUtil.getPublishUri(this.params, container.getID().getName());
        this.params.setAddress(urlStr);
    }

    public Object getProxy(ClassLoader cl, Class[] interfaces) throws ECFException {
        if (interfaces.length == 0) {
            throw new IllegalArgumentException();
        }
        Class<?> interfaceClass = this.getEndpointInterface(interfaces);
        Object port = ClientUtil.getEndpointReference(interfaceClass, (JaxWsParams)this.params);
        return port;
    }

    private Class<?> getEndpointInterface(Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz.getAnnotation(WebService.class) != null) {
                return clazz;
            }
            ++n2;
        }
        return null;
    }

    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        throw new UnsupportedOperationException("Calling JAX-WS Services via IRemoteCallable is not possible, since the concept is too coarse grained");
    }
}

