/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.modelbus.desktop.ApplicationActionBarAdvisor;
import org.modelbus.desktop.model.ModelEditor;
import org.modelbus.desktop.user.UserModelEditor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String PERSPECTIVE_REPOSITORY = "org.modelbus.desktop.perspective.repository";
    private static final String PERSPECTIVE_USERS = "org.modelbus.desktop.perspective.users";
    private List<IEditorReference> hiddenEditors;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShellStyle(8);
    }

    public void postWindowCreate() {
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        shell.setMaximized(true);
        this.hiddenEditors = new ArrayList<IEditorReference>();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new IPerspectiveListener3(){

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                for (IEditorReference editor : ApplicationWorkbenchWindowAdvisor.this.hiddenEditors) {
                    boolean shouldShow = ApplicationWorkbenchWindowAdvisor.this.isEditorPartOfPerspective(editor.getEditor(false), perspective);
                    if (!shouldShow) continue;
                    page.showEditor(editor);
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
            }

            public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IEditorReference[] editors;
                IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editor = iEditorReferenceArray[n2];
                    boolean shouldShow = ApplicationWorkbenchWindowAdvisor.this.isEditorPartOfPerspective(editor.getEditor(false), perspective);
                    if (shouldShow) {
                        ApplicationWorkbenchWindowAdvisor.this.hiddenEditors.add(editor);
                        page.hideEditor(editor);
                    }
                    ++n2;
                }
            }

            public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }
        });
    }

    private boolean isEditorPartOfPerspective(IEditorPart editor, IPerspectiveDescriptor perspective) {
        if (PERSPECTIVE_REPOSITORY.equals(perspective.getId())) {
            return editor instanceof ModelEditor;
        }
        if (PERSPECTIVE_USERS.equals(perspective.getId())) {
            return editor instanceof UserModelEditor;
        }
        return true;
    }
}

