/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.project;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.project.api.AbstractProjectSetup;
import org.modelbus.desktop.project.api.IProjectSetup;
import org.modelbus.dosgi.repository.descriptor.Session;

public class EmptyProjectSetup
extends AbstractProjectSetup
implements IProjectSetup {
    private static final String ERROR_MESSAGE = "Project could not be created. Reason: ";
    private static final String NAME_SPACE = "http://projects";

    @Override
    public boolean createProject(Shell shell, String projectName) {
        Session session = UserSessionHelper.getInstance().getSession();
        IRepositoryHelper repoHelper = ModelBusCoreLib.getRepositoryHelper();
        String projectFolder = "http://projects/" + projectName;
        URI projectFolderURI = URI.createURI((String)projectFolder);
        boolean exists = false;
        File filesTempDir = null;
        try {
            exists = repoHelper.exists(session, projectFolderURI, "-1");
            if (exists) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Project could not be created. Reason: Project folder already exists.");
                return false;
            }
            String resultCreate = repoHelper.createDir(session, projectFolderURI, "Project creation wizard");
            if (!"OK".equals(resultCreate)) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Project could not be created. Reason: Project folder could not be created");
                return false;
            }
            try {
                File tempBaseDir;
                try {
                    tempBaseDir = ModelBusConfiguration.getTempFolder();
                }
                catch (ModelBusException e1) {
                    throw new RuntimeException(e1);
                }
                filesTempDir = new File(String.valueOf(tempBaseDir.getAbsolutePath()) + File.separator + "project_" + projectName);
                if (!filesTempDir.exists() && !filesTempDir.mkdir()) {
                    throw new IOException("Can't create temp folder in: " + filesTempDir.getPath());
                }
                File tempFile = File.createTempFile("temp", "project");
                if (tempFile == null || !tempFile.isFile() || !tempFile.canWrite()) {
                    throw new IOException("Can't write to temp file.");
                }
                FileWriter fstream = new FileWriter(tempFile);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n<name>" + projectName + "</name>\n" + "<comment></comment>\n" + "<projects>\n" + "</projects>\n" + "<buildSpec>\n" + "</buildSpec>\n" + "<natures>\n" + "</natures>\n" + "</projectDescription>");
                out.close();
                URI targetURI = URI.createURI((String)projectFolder).appendSegment(".project");
                repoHelper.checkInFile(session, targetURI, tempFile, "Project descriptor commit");
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        finally {
            if (filesTempDir != null && filesTempDir.exists()) {
                filesTempDir.delete();
            }
        }
        return true;
    }
}

