/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.repository;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.export.ExportRepositoryItemServiceHandler;
import org.modelbus.desktop.export.ExportRepositoryItemsDialog;
import org.modelbus.desktop.export.JobDescriptor;
import org.modelbus.desktop.export.JobRegistry;
import org.modelbus.desktop.model.SelectRevisionDialog;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;

public class ExportRepositoryItemActionDelegate
implements IObjectActionDelegate {
    private final Set<RepositoryDirEntry> dirEntries = new HashSet<RepositoryDirEntry>();
    private Shell shell;

    public void run(IAction action) {
        ExportRepositoryItemServiceHandler handler = new ExportRepositoryItemServiceHandler();
        RWT.getServiceManager().registerServiceHandler("exportServiceHandler", (ServiceHandler)handler);
        if (this.dirEntries.isEmpty()) {
            return;
        }
        SelectRevisionDialog dialog = new SelectRevisionDialog(this.shell, this.dirEntries.iterator().next(), "Select a revision for the export", true);
        int status = dialog.open();
        if (status == 0) {
            String selectedRevision = dialog.getSelectedRevision();
            JobDescriptor descr = new JobDescriptor(this.dirEntries, selectedRevision);
            Integer jobID = JobRegistry.getInstance().addJob(descr);
            ExportRepositoryItemsDialog downloadDialog = new ExportRepositoryItemsDialog(this.shell, descr);
            downloadDialog.open();
            JobRegistry.getInstance().releaseJob(jobID);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.dirEntries.clear();
        if (UserSessionHelper.getInstance().getSession() == null) {
            action.setEnabled(false);
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Iterator selIt = ((IStructuredSelection)selection).iterator();
            while (selIt.hasNext()) {
                this.dirEntries.add((RepositoryDirEntry)selIt.next());
            }
        }
        action.setEnabled(!this.dirEntries.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

