/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.project;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelbus.desktop.project.ProjectSetupTemplateFactory;
import org.modelbus.desktop.project.api.IProjectSetup;

public class NewProjectWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Please specify the project settings";
    private Text projectNameTextField;
    private Combo templateCombo;

    protected NewProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle("New Project");
        this.setDescription(DEFAULT_MESSAGE);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblName.setText("Name:");
        this.projectNameTextField = new Text(container, 2048);
        this.projectNameTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.projectNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String projectName = NewProjectWizardPage.this.projectNameTextField.getText();
                if (projectName == null || "".equals(projectName.trim())) {
                    NewProjectWizardPage.this.setErrorMessage("Project name should not be empty");
                    NewProjectWizardPage.this.setPageComplete(false);
                } else if (projectName.matches("[a-zA-Z0-9_\\.]+")) {
                    NewProjectWizardPage.this.setMessage(NewProjectWizardPage.DEFAULT_MESSAGE, 0);
                    NewProjectWizardPage.this.setPageComplete(true);
                } else {
                    NewProjectWizardPage.this.setErrorMessage("Invalid project name");
                    NewProjectWizardPage.this.setPageComplete(false);
                }
            }
        });
        Label lblTemplate = new Label(container, 0);
        lblTemplate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblTemplate.setText("Template:");
        this.templateCombo = new Combo(container, 8);
        this.templateCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Map<String, IProjectSetup> setupTemplates = ProjectSetupTemplateFactory.getInstance().getProjectSetupTemplates();
        Set<String> templatesNames = setupTemplates.keySet();
        if (!templatesNames.isEmpty()) {
            for (String templateName : templatesNames) {
                this.templateCombo.add(templateName);
            }
            this.templateCombo.setText(templatesNames.iterator().next());
        } else {
            this.setErrorMessage("No project template available");
        }
        this.setPageComplete(false);
    }

    public String getProjectTemplateName() {
        return this.templateCombo.getText();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }
}

