/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.util;

import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.widgets.Display;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.status.ModelBusRepositoryPing;
import org.modelbus.desktop.status.ModelBusStatusProvider;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;

public class ModelBusDesktopUtil {
    private static final long pingInterval = 10000L;
    private ModelBusStatusProvider status;
    private ModelBusRepositoryPing pingThread;

    private ModelBusDesktopUtil() {
    }

    public static ModelBusDesktopUtil getInstance() {
        return (ModelBusDesktopUtil)SingletonUtil.getSessionInstance(ModelBusDesktopUtil.class);
    }

    public static RepositoryDirEntry cloneRepositoryEntry(RepositoryDirEntry entry) {
        RepositoryDirEntry clone = new RepositoryDirEntry();
        clone.setCommitMessage(entry.getCommitMessage());
        clone.setCreationDate(entry.getCreationDate());
        clone.setKind(entry.getKind());
        clone.setLastAuthor(entry.getLastAuthor());
        clone.setName(entry.getName());
        clone.getProperties().addAll(entry.getProperties());
        clone.setRevision(entry.getRevision());
        clone.setSize(entry.getSize());
        clone.setUri(entry.getUri());
        return clone;
    }

    public ModelBusStatusProvider getStatus() {
        if (this.status == null) {
            this.status = new ModelBusStatusProvider();
        }
        return this.status;
    }

    public void initApplication(Display display) {
        UserSessionHelper.setDisplay(display);
        if (this.pingThread == null) {
            ModelBusStatusProvider statusProvider = ModelBusDesktopUtil.getInstance().getStatus();
            UserSessionHelper userSessionHelper = UserSessionHelper.getInstance();
            this.pingThread = new ModelBusRepositoryPing(10000L, display, statusProvider, userSessionHelper);
            this.pingThread.start();
        }
    }
}

