/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.cxfcompat;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.URIID;
import org.eclipse.ecf.provider.jaxws.JaxWsContainer;
import org.eclipse.ecf.provider.jaxws.JaxWsNamespace;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceContainerInstantiator;

public class Instantiator
extends RemoteServiceContainerInstantiator {
    private static final String SERVER_ADDRESS_PARAMETER = "address";
    private static final String SERVER_WSDL_LOCATION_PARAMETER = "wsdl.location";
    private static final String SERVER_WSDL_SERVICE_NAME_PARAMETER = "service.name";
    private static final String SERVER_WSDL_SERVICE_NAMESPACE_PARAMETER = "service.ns";
    private static final String SERVER_WSDL_PORT_NAME_PARAMETER = "wsdl.port.name";
    private static final String SERVER_BINDING_PARAMETER = "binding";
    private static final String SERVER_MTOM_ENABLED_PARAMETER = "mtom.enabled";
    private static final String SERVER_CONNECT_TIMEOUT_PARAMETER = "connect.timeout";
    private static final String SERVER_REQUEST_TIMEOUT_PARAMETER = "request.timeout";
    private static final String PROPERTY_PREFIX = "org.apache.cxf.ws.";

    public Instantiator() {
        super(Arrays.asList("org.apache.cxf.ws"), (Map)new HashMap<String, List<String>>(){
            private static final long serialVersionUID = -4878413071329644935L;
            {
                this.put("org.apache.cxf.ws", Arrays.asList("org.apache.cxf.ws"));
            }
        });
    }

    public IContainer createInstance(ContainerTypeDescription description, Map<String, ?> parameters) throws ContainerCreateException {
        String address = this.getParameterValue(parameters, SERVER_ADDRESS_PARAMETER);
        if (address == null) {
            throw new ContainerCreateException("Property address must be specified");
        }
        JaxWsNamespace namespace = JaxWsNamespace.getInstance();
        URIID id = namespace.createInstance(new Object[]{"jaxws:" + address});
        int defaultTimeout = JaxWsContainer.Instantiator.defaultTimeoutAsInt();
        JaxWsParams params = new JaxWsParams().setAddress(address).setWsdlLocation(this.getParameterValue(parameters, SERVER_WSDL_LOCATION_PARAMETER)).setWsdlServiceName(this.getParameterValue(parameters, SERVER_WSDL_SERVICE_NAME_PARAMETER)).setWsdlServiceNs(this.getParameterValue(parameters, SERVER_WSDL_SERVICE_NAMESPACE_PARAMETER)).setWsdlPortName(this.getParameterValue(parameters, SERVER_WSDL_PORT_NAME_PARAMETER)).setBindingId(this.getParameterValue(parameters, SERVER_BINDING_PARAMETER)).setMtomEnabled(((Boolean)this.getParameterValue(parameters, SERVER_MTOM_ENABLED_PARAMETER, Boolean.class, true)).booleanValue()).setRequestTimeout(((Integer)this.getParameterValue(parameters, SERVER_REQUEST_TIMEOUT_PARAMETER, Integer.class, defaultTimeout)).intValue()).setConnectTimeout(((Integer)this.getParameterValue(parameters, SERVER_CONNECT_TIMEOUT_PARAMETER, Integer.class, defaultTimeout)).intValue());
        return new JaxWsContainer((ID)id, params);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return JaxWsContainer.Instantiator.copyDictionaryRemovingPrefix((Dictionary)exportedProperties, (String)PROPERTY_PREFIX);
    }
}

