/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.util.internal;

import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;

public class JaxWsConfigUtil {
    private JaxWsConfigUtil() {
        throw new IllegalStateException(String.valueOf(JaxWsConfigUtil.class.getName()) + " is not supposed to be instantiated");
    }

    public static QName getServiceName(JaxWsParams params, WebService webServiceDef, WebService endpointDef, Class<?> serviceInterface) {
        String localName = params.getWsdlServiceName();
        if (!JaxWsConfigUtil.isDefined(localName) && webServiceDef != null) {
            localName = webServiceDef.serviceName();
        }
        if (!JaxWsConfigUtil.isDefined(localName) && endpointDef != null) {
            localName = endpointDef.serviceName();
        }
        if (!JaxWsConfigUtil.isDefined(localName) && serviceInterface != null) {
            localName = serviceInterface.getSimpleName();
        }
        String namespace = JaxWsConfigUtil.getNamespace(params, webServiceDef, endpointDef, serviceInterface, localName);
        return new QName(namespace, localName);
    }

    public static QName getPortName(JaxWsParams params, WebService webServiceDef, WebService endpointDef, Class<?> serviceInterface) {
        String localName = params.getWsdlServiceName();
        if (!JaxWsConfigUtil.isDefined(localName) && webServiceDef != null) {
            localName = webServiceDef.portName();
        }
        if (!JaxWsConfigUtil.isDefined(localName) && endpointDef != null) {
            localName = endpointDef.portName();
        }
        if (!JaxWsConfigUtil.isDefined(localName) && serviceInterface != null) {
            localName = String.valueOf(serviceInterface.getSimpleName()) + "Port";
        }
        String namespace = JaxWsConfigUtil.getNamespace(params, webServiceDef, endpointDef, serviceInterface, localName);
        return new QName(namespace, localName);
    }

    private static String getNamespace(JaxWsParams params, WebService webServiceDef, WebService endpointDef, Class<?> serviceInterface, String localName) {
        String namespace = params.getWsdlServiceNs();
        if (!JaxWsConfigUtil.isDefined(namespace) && webServiceDef != null) {
            namespace = webServiceDef.targetNamespace();
        }
        if (!JaxWsConfigUtil.isDefined(namespace) && endpointDef != null) {
            namespace = endpointDef.targetNamespace();
        }
        if (!JaxWsConfigUtil.isDefined(namespace)) {
            namespace = "http://" + serviceInterface.getPackage().getName();
        }
        return namespace;
    }

    private static boolean isDefined(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

